/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.string.CombinedStringSearcher;
import ghidra.app.plugin.core.string.FoundStringWithWordStatus;
import ghidra.app.plugin.core.string.StringTableOptions;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.string.FoundString;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.CodeUnitTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;

public class StringTableModel
extends AddressBasedTableModel<FoundString> {
    private volatile StringTableOptions options;

    StringTableModel(PluginTool tool, StringTableOptions options) {
        super("Strings Table", (ServiceProvider)tool, null, null, true);
        this.options = options;
        if (options.getWordModelInitialized()) {
            this.addTableColumn((DynamicTableColumn)new ConfidenceWordTableColumn());
        }
    }

    @Override
    public Address getAddress(int row) {
        FoundString stringData = (FoundString)this.getRowObject(row);
        return stringData.getAddress();
    }

    void setOptions(StringTableOptions options) {
        this.options = options;
    }

    protected void doLoad(Accumulator<FoundString> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.getProgram() == null) {
            return;
        }
        CombinedStringSearcher searcher = new CombinedStringSearcher(this.getProgram(), this.options, accumulator);
        searcher.search(monitor);
    }

    @Override
    protected TableColumnDescriptor<FoundString> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new IsDefinedTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 0, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new CodeUnitTableColumn()));
        descriptor.addVisibleColumn((DynamicTableColumn)new StringViewTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new StringTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new StringLengthTableColumn());
        return descriptor;
    }

    private class ConfidenceWordTableColumn
    extends AbstractProgramBasedDynamicTableColumn<FoundString, String> {
        private ConfidenceWordTableColumn() {
        }

        public String getColumnName() {
            return "Is Word";
        }

        public String getColumnDescription() {
            return "Whether the string is a high-confidence word string, according to the '" + StringTableModel.this.options.getWordModelFile() + "' model.";
        }

        public String getValue(FoundString rowObject, Settings settings, Program p, ServiceProvider services) throws IllegalArgumentException {
            if (rowObject instanceof FoundStringWithWordStatus) {
                return Boolean.valueOf(((FoundStringWithWordStatus)rowObject).isHighConfidenceWord()).toString();
            }
            return "N/A - Model Error";
        }
    }

    class StringViewTableColumn
    extends AbstractProgramBasedDynamicTableColumn<FoundString, String> {
        StringViewTableColumn() {
        }

        public String getColumnName() {
            return "String View";
        }

        public String getValue(FoundString foundString, Settings settings, Program program, ServiceProvider services) throws IllegalArgumentException {
            return foundString != null && foundString.getLength() > 0 ? foundString.getDataInstance(StringTableModel.this.getProgram().getMemory()).getStringRepresentation() : "";
        }
    }

    static class IsDefinedTableColumn
    extends AbstractProgramBasedDynamicTableColumn<FoundString, FoundString.DefinedState> {
        IsDefinedTableColumn() {
        }

        public String getColumnName() {
            return "Defined";
        }

        public FoundString.DefinedState getValue(FoundString rowObject, Settings settings, Program program, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getDefinedState();
        }

        public int getColumnPreferredWidth() {
            return 40;
        }
    }

    static class StringLengthTableColumn
    extends AbstractProgramBasedDynamicTableColumn<FoundString, Integer> {
        StringLengthTableColumn() {
        }

        public String getColumnName() {
            return "Length";
        }

        public Integer getValue(FoundString rowObject, Settings settings, Program program, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getStringLength(program.getMemory());
        }

        public int getColumnPreferredWidth() {
            return 80;
        }
    }

    static class StringTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<FoundString, String> {
        StringTypeTableColumn() {
        }

        public String getColumnName() {
            return "String Type";
        }

        public String getValue(FoundString rowObject, Settings settings, Program program, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getDataType().toString();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }
}

