/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Symbol Tree", description="This plugin shows the symbols from the program in a tree hierarchy.  All symbols (except for the global namespace symbol) have a parent symbol.  From the tree, symbols can be renamed, deleted, or reorganized.", eventsConsumed={ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramClosedPluginEvent.class})
public class SymbolTreePlugin
extends Plugin {
    public static final String PLUGIN_NAME = "SymbolTreePlugin";
    private DockingAction symTreeAction;
    private SymbolTreeProvider provider;
    private Program program;
    private GoToService goToService;
    private boolean processingGoTo;
    static final ImageIcon SYMBOL_TREE_ICON = ResourceManager.loadImage((String)"images/sitemap_color.png");

    public SymbolTreePlugin(PluginTool tool) {
        super(tool);
        this.createAction();
        this.provider = new SymbolTreeProvider(tool, this);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program oldProgram = this.program;
            this.program = ev.getActiveProgram();
            if (oldProgram != null) {
                this.provider.programDeactivated(oldProgram);
            }
            if (this.program != null) {
                this.provider.programActivated(this.program);
            }
        } else if (event instanceof ProgramClosedPluginEvent) {
            this.provider.programClosed(((ProgramClosedPluginEvent)event).getProgram());
        } else if (event instanceof ProgramLocationPluginEvent) {
            if (this.processingGoTo) {
                return;
            }
            ProgramLocation loc = ((ProgramLocationPluginEvent)event).getLocation();
            this.provider.locationChanged(loc);
        }
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        this.provider.dispose();
        this.program = null;
    }

    public void readConfigState(SaveState saveState) {
        this.provider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.provider.writeConfigState(saveState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goTo(Symbol symbol) {
        SymbolType type = symbol.getSymbolType();
        if (type.isNamespace() && type != SymbolType.FUNCTION) {
            this.tool.setStatusInfo("Can not navigate to " + (symbol.isExternal() ? "external " : "") + type.toString() + " symbol: " + symbol.getName());
            return;
        }
        boolean success = false;
        String reason = "";
        if (this.goToService != null) {
            this.processingGoTo = true;
            try {
                ProgramLocation loc = symbol.getProgramLocation();
                if (symbol.getAddress().isExternalAddress()) {
                    this.goToService.goTo(symbol.getAddress(), this.program);
                    return;
                }
                if (loc != null) {
                    reason = " (not in-memory)";
                    success = this.goToService.goTo(loc);
                }
            }
            finally {
                this.processingGoTo = false;
            }
        }
        if (!success) {
            this.tool.setStatusInfo("Can not navigate to " + (symbol.isExternal() ? "external " : "") + type.toString() + " symbol: " + symbol.getName() + reason);
        }
    }

    public void goTo(ExternalLocation extLoc) {
        this.goToService.goToExternalLocation(extLoc, false);
    }

    private void createAction() {
        this.symTreeAction = new DockingAction("Display Symbol Tree", this.getName()){

            public void actionPerformed(ActionContext context) {
                SymbolTreePlugin.this.showProvider();
            }
        };
        this.symTreeAction.setToolBarData(new ToolBarData((Icon)SYMBOL_TREE_ICON, "View"));
        this.symTreeAction.setDescription("Display Symbol Tree");
        this.symTreeAction.setHelpLocation(new HelpLocation(this.getName(), "SymbolTree"));
        this.tool.addAction((DockingActionIf)this.symTreeAction);
    }

    private void showProvider() {
        this.provider.showComponent(this.program);
    }

    public Program getProgram() {
        return this.program;
    }

    SymbolTreeProvider getProvider() {
        return this.provider;
    }
}

