/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.dbtable;

import db.BinaryField;
import db.Record;
import ghidra.app.plugin.debug.dbtable.AbstractColumnAdapter;

public class BinaryColumnAdapter
extends AbstractColumnAdapter {
    @Override
    Class<?> getValueClass() {
        return String.class;
    }

    @Override
    Object getKeyValue(Record rec) {
        byte[] bytes = ((BinaryField)rec.getKeyField()).getBinaryData();
        StringBuffer buf = new StringBuffer("  byte[" + bytes.length + "] = ");
        if (bytes.length > 0) {
            int len = Math.min(bytes.length, 20);
            buf.append(bytes[0]);
            for (int i = 1; i < len; ++i) {
                buf.append(",");
                buf.append(bytes[i]);
            }
            if (bytes.length > 20) {
                buf.append("...");
            }
        }
        return buf.toString();
    }

    @Override
    Object getValue(Record rec, int col) {
        byte[] bytes = rec.getBinaryData(col);
        if (bytes == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer("  byte[" + bytes.length + "] = ");
        if (bytes.length > 0) {
            int len = Math.min(bytes.length, 20);
            String str = this.getByteString(bytes[0]);
            buf.append(str);
            for (int i = 1; i < len; ++i) {
                buf.append(",");
                buf.append(this.getByteString(bytes[i]));
            }
            if (bytes.length > 20) {
                buf.append("...");
            }
        }
        return buf.toString();
    }
}

