/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfFixupRecord;
import ghidra.app.util.bin.format.omf.OmfRecord;
import java.io.IOException;

public class OmfModuleEnd
extends OmfRecord {
    private byte moduleType;
    private OmfFixupRecord.FixupTarget startAddress;

    public OmfModuleEnd(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        this.moduleType = reader.readNextByte();
        if (this.hasStartAddress()) {
            this.startAddress = OmfFixupRecord.FixupTarget.readFixupTarget(reader, this.hasBigFields());
        }
        this.readCheckSumByte(reader);
    }

    public boolean isMainProgramModule() {
        return (this.moduleType & 0x80) != 0;
    }

    public boolean hasStartAddress() {
        return (this.moduleType & 0x40) != 0;
    }
}

