/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileLocal;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LocalFileSystemSub
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private final GFileSystem rootFS;
    private final List<GFile> emptyDir = Collections.emptyList();
    private File localfsRootDir;
    private FileSystemRefManager refManager = new FileSystemRefManager(this);
    private GFileLocal rootGFile;

    public LocalFileSystemSub(File rootDir, GFileSystem rootFS) throws IOException {
        this.rootFS = rootFS;
        this.localfsRootDir = rootDir.getCanonicalFile();
        GFile containerDir = rootFS.lookup(this.localfsRootDir.getPath());
        if (containerDir == null) {
            throw new IOException("Bad root dir: " + rootDir);
        }
        this.fsFSRL = FSRLRoot.nestedFS(containerDir.getFSRL(), rootFS.getFSRL().getProtocol());
        this.rootGFile = new GFileLocal(this.localfsRootDir, "/", containerDir.getFSRL(), this, null);
    }

    @Override
    public String getType() {
        return this.rootFS.getType();
    }

    @Override
    public String getDescription() {
        return "Local filesystem subdirectory";
    }

    @Override
    public void close() {
        this.refManager.onClose();
        this.localfsRootDir = null;
    }

    @Override
    public boolean isClosed() {
        return this.localfsRootDir == null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    private File getFileFromGFile(GFile gf) throws IOException {
        if (gf == null) {
            return this.localfsRootDir;
        }
        if (!(gf instanceof GFileLocal)) {
            throw new IOException("Unexpected GFile class: " + gf.getClass());
        }
        return ((GFileLocal)gf).getLocalFile();
    }

    @Override
    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null) {
            directory = this.rootGFile;
        }
        if (!directory.isDirectory()) {
            return this.emptyDir;
        }
        File localDir = this.getFileFromGFile(directory);
        if (Files.isSymbolicLink(localDir.toPath())) {
            return this.emptyDir;
        }
        File[] localFiles = localDir.listFiles();
        if (localFiles == null) {
            return this.emptyDir;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>(localFiles.length);
        FSRL dirFSRL = directory.getFSRL();
        String relPath = FSUtilities.normalizeNativePath(directory.getPath());
        for (File f : localFiles) {
            if (!f.isFile() && !f.isDirectory()) continue;
            String name = f.getName();
            GFileLocal gf = new GFileLocal(f, FSUtilities.appendPath(relPath, name), dirFSRL.appendPath(name), this, directory);
            tmp.add(gf);
        }
        return tmp;
    }

    @Override
    public String getInfo(GFile file, TaskMonitor monitor) throws IOException {
        File localFile = this.getFileFromGFile(file);
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name: " + localFile.getName() + "\n");
        buffer.append("Size: " + localFile.length() + "\n");
        buffer.append("Date: " + new Date(localFile.lastModified()).toString() + "\n");
        return buffer.toString();
    }

    @Override
    public String getName() {
        return "Subdir " + this.localfsRootDir.getPath();
    }

    @Override
    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    @Override
    public GFile lookup(String path) throws IOException {
        String[] parts;
        path = StringUtils.defaultString((String)path, (String)"/");
        File curFile = this.localfsRootDir;
        GFileLocal result = this.rootGFile;
        for (String name : parts = path.split("/")) {
            if (name.isEmpty()) continue;
            curFile = new File(curFile, name);
            FSRL fsrl = result.getFSRL().appendPath(name);
            String relPath = FSUtilities.appendPath(result.getPath(), name);
            result = new GFileLocal(curFile, relPath, fsrl, this, result);
        }
        return result;
    }

    @Override
    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        return new FileInputStream(this.getFileFromGFile(file));
    }

    @Override
    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public String toString() {
        return this.getName();
    }
}

