/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis.gui;

import ghidra.app.services.Analyzer;
import ghidra.framework.analysis.AnalysisPhase;
import ghidra.framework.analysis.AnalysisRecipe;
import ghidra.framework.analysis.AnalysisRecipeEditor;
import ghidra.framework.analysis.GhidraScriptAnalyzerAdapter;
import ghidra.framework.analysis.gui.AnalyzerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AnalyzerListPanel
extends JPanel {
    private AnalysisRecipe recipe;
    private AnalysisPhase relevantPhase;
    private JList<Analyzer> jList;
    private AnalysisRecipeEditor editor;
    private AnalyzerListModel model;

    public AnalyzerListPanel(AnalysisRecipeEditor editor, AnalysisRecipe recipe, AnalysisPhase phase) {
        super(new BorderLayout());
        this.editor = editor;
        this.recipe = recipe;
        this.relevantPhase = phase;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane jScrollPane = new JScrollPane(this.buildAnalyzerList());
        jScrollPane.setColumnHeaderView(this.buildHeader());
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        this.add((Component)jScrollPane, "Center");
        if (phase != null) {
            final JCheckBox checkbox = new JCheckBox("Create Checkpoint When Phase Completed");
            checkbox.setSelected(phase.isCheckPoint());
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalyzerListPanel.this.relevantPhase.setIsCheckPoint(checkbox.isSelected());
                }
            });
            this.add((Component)checkbox, "South");
            if (phase == recipe.getLastPhase()) {
                checkbox.setEnabled(false);
            }
        }
    }

    public List<Analyzer> getSelectedAnalyzers() {
        int[] selectedIndices = this.jList.getSelectedIndices();
        ArrayList<Analyzer> analyzers = new ArrayList<Analyzer>();
        for (int i : selectedIndices) {
            analyzers.add(this.model.getElementAt(i));
        }
        return analyzers;
    }

    private JList<Analyzer> buildAnalyzerList() {
        this.model = new AnalyzerListModel(this.recipe.getAnalyzers(this.relevantPhase));
        this.jList = new JList<Analyzer>((ListModel)this.model){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int row = AnalyzerListPanel.this.jList.locationToIndex(p);
                Rectangle b = AnalyzerListPanel.this.jList.getCellBounds(row, row);
                p.x -= b.x;
                p.y -= b.y;
                ListCellRenderer<Analyzer> cellRenderer = AnalyzerListPanel.this.jList.getCellRenderer();
                Analyzer analyzer = AnalyzerListPanel.this.jList.getModel().getElementAt(row);
                JComponent comp = (JComponent)cellRenderer.getListCellRendererComponent(AnalyzerListPanel.this.jList, analyzer, row, true, true);
                comp.setBounds(b.x, b.y, b.width, b.height);
                JComponent c = (JComponent)SwingUtilities.getDeepestComponentAt(comp, p.x, p.y);
                return c.getToolTipText();
            }
        };
        this.jList.setCellRenderer(new AnalyzerCellRenderer());
        this.jList.setPrototypeCellValue(this.getAnalyzerWithLongestName());
        this.jList.setVisibleRowCount(14);
        this.jList.addMouseListener(new AnalyzerListMouseListener());
        this.jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List<Analyzer> selectedValues = AnalyzerListPanel.this.jList.getSelectedValuesList();
                if (selectedValues.size() == 1) {
                    AnalyzerListPanel.this.editor.setSelectedAnalyzer(selectedValues.iterator().next());
                } else {
                    AnalyzerListPanel.this.editor.setSelectedAnalyzer(null);
                }
            }
        });
        this.jList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (keyChar == ' ') {
                    List<Analyzer> selectedValues = AnalyzerListPanel.this.jList.getSelectedValuesList();
                    if (selectedValues.size() == 1) {
                        Analyzer analyzer = selectedValues.iterator().next();
                        AnalyzerListPanel.this.recipe.setAnalyzerEnablement(analyzer, !AnalyzerListPanel.this.recipe.isAnalyzerEnabled(analyzer));
                    }
                } else if (keyChar >= '1' && keyChar <= '9') {
                    AnalyzerListPanel.this.setPhaseForSelectedAnalyzers(keyChar - 49);
                }
            }
        });
        return this.jList;
    }

    private Component buildHeader() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        panel.add((Component)new JLabel("ANALYZERS", 0), "Center");
        panel.add(this.buildPhaseHeader(), "East");
        return panel;
    }

    private Component buildPhaseHeader() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        panel.add((Component)new JLabel("PHASE", 0), "South");
        Dimension dim = panel.getPreferredSize();
        dim.width = this.getAnalysisPanelPhaseWidth();
        panel.setPreferredSize(dim);
        return panel;
    }

    private int getAnalysisPanelPhaseWidth() {
        AnalyzerPanel panel = new AnalyzerPanel(this.recipe.getAnalyzers().get(0), this.recipe, null);
        return panel.getPhasePanelWidth();
    }

    private Analyzer getAnalyzerWithLongestName() {
        List<Analyzer> analyzers = this.recipe.getAnalyzers();
        Analyzer longestAnalyzer = analyzers.get(0);
        AnalyzerPanel panel = new AnalyzerPanel(longestAnalyzer, this.recipe, null);
        int longestWidth = panel.getPreferredSize().width;
        for (Analyzer analyzer : analyzers) {
            panel.setAnalyzer(analyzer);
            if (panel.getPreferredSize().width <= longestWidth) continue;
            longestWidth = panel.getPreferredSize().width;
            longestAnalyzer = analyzer;
        }
        return longestAnalyzer;
    }

    protected void popupMenu(Point p) {
        JPopupMenu menu = new JPopupMenu("Set Phase");
        List<AnalysisPhase> phases = this.recipe.getAnalysisPhases();
        for (AnalysisPhase analysisPhase : phases) {
            menu.add(this.createMenuItem(analysisPhase));
        }
        this.addMenuItemToDeleteWrappedAnalyzerScripts(menu);
        menu.show(this.jList, p.x, p.y);
    }

    private void addMenuItemToDeleteWrappedAnalyzerScripts(JPopupMenu menu) {
        List<Analyzer> selectedValues = this.jList.getSelectedValuesList();
        if (selectedValues.size() != 1) {
            return;
        }
        final Analyzer analyzer = selectedValues.iterator().next();
        if (analyzer instanceof GhidraScriptAnalyzerAdapter) {
            JMenuItem jMenuItem = new JMenuItem("Delete Script Analyzer: " + analyzer.getName());
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalyzerListPanel.this.recipe.deleteScriptAnalyzer(analyzer);
                }
            });
            menu.addSeparator();
            menu.add(jMenuItem);
        }
    }

    private JMenuItem createMenuItem(final AnalysisPhase analysisPhase) {
        JMenuItem jMenuItem = new JMenuItem("Set Start Phase to " + analysisPhase);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalyzerListPanel.this.setPhaseForSelectedAnalyzers(analysisPhase.getIndex());
            }
        });
        return jMenuItem;
    }

    public void refresh() {
        this.model.setAnalyzers(this.recipe.getAnalyzers(this.relevantPhase));
    }

    protected void setPhaseForSelectedAnalyzers(int phaseIndex) {
        List<AnalysisPhase> phases = this.recipe.getAnalysisPhases();
        if (phaseIndex >= phases.size()) {
            return;
        }
        AnalysisPhase phase = phases.get(phaseIndex);
        Iterator<Analyzer> iterator = this.jList.getSelectedValuesList().iterator();
        while (iterator.hasNext()) {
            Analyzer object;
            Analyzer analyzer = object = iterator.next();
            this.recipe.setAnalyzerStartPhase(analyzer, phase);
        }
    }

    private class AnalyzerListMouseListener
    extends MouseAdapter {
        private AnalyzerListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int row = AnalyzerListPanel.this.jList.locationToIndex(p);
            if (e.getButton() == 1) {
                Rectangle b = AnalyzerListPanel.this.jList.getCellBounds(row, row);
                p.x -= b.x;
                p.y -= b.y;
                ListCellRenderer<Analyzer> cellRenderer = AnalyzerListPanel.this.jList.getCellRenderer();
                Analyzer analyzer = AnalyzerListPanel.this.jList.getModel().getElementAt(row);
                Component comp = cellRenderer.getListCellRendererComponent(AnalyzerListPanel.this.jList, analyzer, row, true, true);
                comp.setBounds(0, 0, b.width, b.height);
                Component c = SwingUtilities.getDeepestComponentAt(comp, p.x, p.y);
                if (c instanceof JCheckBox) {
                    ((JCheckBox)c).doClick();
                    AnalyzerListPanel.this.jList.repaint();
                }
            } else if (e.getButton() == 3 && AnalyzerListPanel.this.jList.isSelectedIndex(row)) {
                AnalyzerListPanel.this.popupMenu(p);
            }
        }
    }

    private static class AnalyzerListModel
    extends AbstractListModel<Analyzer> {
        private List<Analyzer> list;

        AnalyzerListModel(List<Analyzer> list) {
            this.list = list;
        }

        public void setAnalyzers(List<Analyzer> analyzers) {
            if (this.analyzersChanged(analyzers)) {
                this.list = analyzers;
                this.fireContentsChanged(this, 0, this.list.size());
            }
        }

        private boolean analyzersChanged(List<Analyzer> analyzers) {
            if (analyzers.size() != this.list.size()) {
                return true;
            }
            for (int i = 0; i < this.list.size(); ++i) {
                if (analyzers.get(i) == this.list.get(i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public Analyzer getElementAt(int index) {
            return this.list.get(index);
        }
    }

    private class AnalyzerCellRenderer
    implements ListCellRenderer<Analyzer> {
        private AnalyzerPanel analyzerPanel;

        AnalyzerCellRenderer() {
            this.analyzerPanel = new AnalyzerPanel(AnalyzerListPanel.this.recipe.getAnalyzers().get(0), AnalyzerListPanel.this.recipe, AnalyzerListPanel.this.relevantPhase);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Analyzer> list, Analyzer value, int index, boolean isSelected, boolean cellHasFocus) {
            Analyzer analyzer = value;
            this.analyzerPanel.setAnalyzer(analyzer);
            this.analyzerPanel.setSelected(isSelected);
            return this.analyzerPanel;
        }
    }
}

