/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.beans.factories;

import com.jeta.forms.gui.beans.BeanProperties;
import com.jeta.forms.gui.beans.DynamicBeanInfo;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.factories.BeanFactory;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.properties.CompoundBorderProperty;
import com.jeta.forms.store.properties.DefaultBorderProperty;
import com.jeta.forms.store.properties.ScrollBarsProperty;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;

public class JComponentBeanFactory
implements BeanFactory {
    private Class m_comp_class;
    private String m_short_name;
    private boolean m_scrollable = false;

    public JComponentBeanFactory(Class clazz) {
        this.setBeanClass(clazz);
    }

    public JETABean createBean(String string, boolean bl, boolean bl2) throws FormException {
        Component component = null;
        if (bl) {
            component = this.instantiateBean();
            component.setName(string);
        }
        DynamicBeanInfo dynamicBeanInfo = JComponentBeanFactory.createBeanInfo(this.m_comp_class);
        BeanProperties beanProperties = new BeanProperties(dynamicBeanInfo);
        this.defineProperties(beanProperties);
        return new JETABean(component, beanProperties);
    }

    public static DynamicBeanInfo createBeanInfo(Class clazz) throws FormException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            return new DynamicBeanInfo(beanInfo);
        }
        catch (Exception exception) {
            FormsLogger.severe(exception);
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            throw new FormException(exception);
        }
    }

    public Class getBeanClass() {
        return this.m_comp_class;
    }

    public void defineProperties(BeanProperties beanProperties) {
        CompoundBorderProperty compoundBorderProperty = new CompoundBorderProperty();
        compoundBorderProperty.addBorder(new DefaultBorderProperty());
        beanProperties.register(compoundBorderProperty);
        if (this.isScrollable()) {
            beanProperties.register(new ScrollBarsProperty());
        }
    }

    public String getShortBeanClassName() {
        return this.m_short_name;
    }

    public Component instantiateBean() throws FormException {
        try {
            return (Component)this.m_comp_class.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new FormException(exception);
        }
    }

    public boolean isScrollable() {
        return this.m_scrollable;
    }

    public void setBeanClass(Class clazz) {
        this.m_comp_class = clazz;
        try {
            String string = clazz.getName();
            int n = string.lastIndexOf(".");
            if (n > 0) {
                string = string.substring(n + 1, string.length());
            }
            this.m_short_name = string;
        }
        catch (Exception exception) {
            this.m_short_name = clazz.getName();
        }
    }

    public void setScrollable(boolean bl) {
        this.m_scrollable = bl;
    }
}

