/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.AbstractIterator;
import javaslang.collection.HashSet;
import javaslang.collection.IteratorModule;
import javaslang.collection.Queue;
import javaslang.collection.Seq;
import javaslang.collection.Stream;
import javaslang.collection.Traversable;
import javaslang.collection.TreeSet;
import javaslang.control.Option;

public interface Iterator<T>
extends java.util.Iterator<T>,
Traversable<T> {
    @Deprecated
    public static final Iterator<Object> EMPTY = IteratorModule.EmptyIterator.INSTANCE;

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterable<? extends T> ... iterables) {
        Objects.requireNonNull(iterables, "iterables is null");
        if (iterables.length == 0) {
            return Iterator.empty();
        }
        return new IteratorModule.ConcatIterator(Stream.of(iterables).map(Iterator::ofAll).iterator());
    }

    public static <T> Iterator<T> empty() {
        return IteratorModule.EmptyIterator.INSTANCE;
    }

    public static <T> Iterator<T> of(final T element) {
        return new AbstractIterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T getNext() {
                this.hasNext = false;
                return element;
            }
        };
    }

    public static <T> Iterator<T> ofAll(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        if (iterable instanceof Iterator) {
            return (Iterator)iterable;
        }
        return Iterator.ofAll(iterable.iterator());
    }

    public static <T> Iterator<T> ofAll(final java.util.Iterator<? extends T> iterator2) {
        Objects.requireNonNull(iterator2, "iterator is null");
        if (iterator2 instanceof Iterator) {
            return (Iterator)iterator2;
        }
        return new AbstractIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T getNext() {
                return iterator2.next();
            }
        };
    }

    default public Iterator<T> intersperse(final T element) {
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            boolean insertElement = false;

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public T getNext() {
                if (this.insertElement) {
                    this.insertElement = false;
                    return element;
                }
                this.insertElement = true;
                return that.next();
            }
        };
    }

    default public Iterator<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        return new IteratorModule.DistinctIterator(this, TreeSet.empty(comparator), Function.identity());
    }

    default public <U> Iterator<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        return new IteratorModule.DistinctIterator<T, U>(this, HashSet.empty(), keyExtractor);
    }

    default public Iterator<T> drop(final long n) {
        if (n <= 0L) {
            return this;
        }
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            long count;
            {
                this.count = n;
            }

            @Override
            public boolean hasNext() {
                while (this.count > 0L && that.hasNext()) {
                    that.next();
                    --this.count;
                }
                return that.hasNext();
            }

            @Override
            public T getNext() {
                return that.next();
            }
        };
    }

    default public Iterator<T> dropRight(final long n) {
        if (n <= 0L) {
            return this;
        }
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private Queue<T> queue = Queue.empty();

            @Override
            public boolean hasNext() {
                while ((long)this.queue.length() < n && that.hasNext()) {
                    this.queue = this.queue.append(that.next());
                }
                return (long)this.queue.length() == n && that.hasNext();
            }

            @Override
            public T getNext() {
                Tuple2 t = this.queue.append(that.next()).dequeue();
                this.queue = (Queue)t._2;
                return t._1;
            }
        };
    }

    default public Iterator<T> dropWhile(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private T next;
            private boolean cached = false;
            private boolean first = true;

            @Override
            public boolean hasNext() {
                if (this.cached) {
                    return true;
                }
                if (this.first) {
                    this.first = false;
                    while (that.hasNext()) {
                        this.next = that.next();
                        if (predicate.test(this.next)) continue;
                        this.cached = true;
                        return true;
                    }
                    return false;
                }
                if (that.hasNext()) {
                    this.next = that.next();
                    this.cached = true;
                    return true;
                }
                return false;
            }

            @Override
            public T getNext() {
                this.cached = false;
                return this.next;
            }
        };
    }

    default public Iterator<T> filter(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            Option<T> next = Option.none();

            @Override
            public boolean hasNext() {
                while (this.next.isEmpty() && that.hasNext()) {
                    Object candidate2 = that.next();
                    if (!predicate.test(candidate2)) continue;
                    this.next = Option.some(candidate2);
                }
                return this.next.isDefined();
            }

            @Override
            public T getNext() {
                Object result2 = this.next.get();
                this.next = Option.none();
                return result2;
            }
        };
    }

    @Override
    default public T get() {
        return this.head();
    }

    @Override
    default public T head() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("head() on empty iterator");
        }
        return (T)this.next();
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    @Override
    default public boolean isTraversableAgain() {
        return false;
    }

    @Override
    default public Iterator<T> iterator() {
        return this;
    }

    @Override
    default public int length() {
        return this.foldLeft(0, (n, ignored) -> n + 1);
    }

    default public <U> Iterator<U> map(final Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public U getNext() {
                return mapper.apply(that.next());
            }
        };
    }

    default public Tuple2<Iterator<T>, Iterator<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Tuple.of(Iterator.empty(), Iterator.empty());
        }
        Stream that = Stream.ofAll(this);
        Iterator<? super T> first2 = that.iterator().filter(predicate);
        Iterator<? super T> second = that.iterator().filter(predicate.negate());
        return Tuple.of(first2, second);
    }

    @Override
    default public T reduceLeft(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        if (this.isEmpty()) {
            throw new NoSuchElementException("reduceLeft on Nil");
        }
        Stream stream = Stream.ofAll(this);
        return stream.tail().foldLeft(stream.head(), op);
    }

    default public Iterator<Seq<T>> sliding(long size, long step) {
        return new IteratorModule.GroupedIterator(this, (int)size, (int)step);
    }

    default public Tuple2<Iterator<T>, Iterator<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Tuple.of(Iterator.empty(), Iterator.empty());
        }
        Stream that = Stream.ofAll(this);
        return Tuple.of(that.iterator().takeWhile(predicate), that.iterator().dropWhile(predicate));
    }

    @Override
    default public Spliterator<T> spliterator() {
        Stream stream = Stream.ofAll(this);
        return Spliterators.spliterator(stream.iterator(), (long)stream.length(), 1040);
    }

    @Override
    default public String stringPrefix() {
        return "Iterator";
    }

    @Override
    default public Iterator<T> tail() {
        if (!this.hasNext()) {
            throw new UnsupportedOperationException();
        }
        this.next();
        return this;
    }

    default public Iterator<T> take(final long n) {
        if (n <= 0L || !this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            long count;
            {
                this.count = n;
            }

            @Override
            public boolean hasNext() {
                return this.count > 0L && that.hasNext();
            }

            @Override
            public T getNext() {
                --this.count;
                return that.next();
            }
        };
    }

    default public Iterator<T> takeRight(final long n) {
        if (n <= 0L) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private Queue<T> queue = Queue.empty();

            @Override
            public boolean hasNext() {
                while (that.hasNext()) {
                    this.queue = this.queue.enqueue(that.next());
                    if ((long)this.queue.length() <= n) continue;
                    this.queue = (Queue)this.queue.dequeue()._2;
                }
                return this.queue.length() > 0;
            }

            @Override
            public T getNext() {
                Tuple2 t = this.queue.dequeue();
                this.queue = (Queue)t._2;
                return t._1;
            }
        };
    }

    default public Iterator<T> takeWhile(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private T next;
            private boolean cached = false;
            private boolean finished = false;

            @Override
            public boolean hasNext() {
                if (this.cached) {
                    return true;
                }
                if (this.finished) {
                    return false;
                }
                if (that.hasNext()) {
                    this.next = that.next();
                    if (predicate.test(this.next)) {
                        this.cached = true;
                        return true;
                    }
                }
                this.finished = true;
                return false;
            }

            @Override
            public T getNext() {
                this.cached = false;
                return this.next;
            }
        };
    }
}

