/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.structure.CallComputation;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESBooleanType;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESReceiver;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B!\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/Substitutor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "substitutions", "", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "reducer", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;)V", "visitAnd", "and", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitConstant", "esConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "visitEqual", "equal", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitIs", "isOperator", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitNot", "not", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitOr", "or", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitReceiver", "Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "esReceiver", "visitVariable", "esVariable", "resolution"})
public final class Substitutor
implements ESExpressionVisitor<Computation> {
    private final Map<ESVariable, Computation> substitutions;
    private final Reducer reducer;

    @Override
    @Nullable
    public Computation visitIs(@NotNull ESIs isOperator) {
        Intrinsics.checkParameterIsNotNull((Object)isOperator, (String)"isOperator");
        Computation computation = (Computation)isOperator.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(ESBooleanType.INSTANCE, isOperator.getFunctor().invokeWithArguments(arg));
    }

    @Override
    @Nullable
    public Computation visitNot(@NotNull ESNot not) {
        Intrinsics.checkParameterIsNotNull((Object)not, (String)"not");
        Computation computation = (Computation)not.getArg().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(ESBooleanType.INSTANCE, not.getFunctor().invokeWithArguments(arg));
    }

    @Override
    @Nullable
    public Computation visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkParameterIsNotNull((Object)equal, (String)"equal");
        Computation computation = (Computation)equal.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)equal.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, equal.getFunctor().invokeWithArguments(CollectionsKt.listOf((Object[])new Computation[]{left, right}), this.reducer));
    }

    @Override
    @Nullable
    public Computation visitAnd(@NotNull ESAnd and) {
        Intrinsics.checkParameterIsNotNull((Object)and, (String)"and");
        Computation computation = (Computation)and.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)and.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, and.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @Nullable
    public Computation visitOr(@NotNull ESOr or2) {
        Intrinsics.checkParameterIsNotNull((Object)or2, (String)"or");
        Computation computation = (Computation)or2.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)or2.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, or2.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @Nullable
    public Computation visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkParameterIsNotNull((Object)esVariable, (String)"esVariable");
        Computation computation = this.substitutions.get(esVariable);
        if (computation == null) {
            computation = esVariable;
        }
        return computation;
    }

    @Override
    @Nullable
    public Computation visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkParameterIsNotNull((Object)esConstant, (String)"esConstant");
        return esConstant;
    }

    @Override
    @NotNull
    public ESReceiver visitReceiver(@NotNull ESReceiver esReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)esReceiver, (String)"esReceiver");
        return esReceiver;
    }

    public Substitutor(@NotNull Map<ESVariable, ? extends Computation> substitutions, @NotNull Reducer reducer) {
        Intrinsics.checkParameterIsNotNull(substitutions, (String)"substitutions");
        Intrinsics.checkParameterIsNotNull((Object)reducer, (String)"reducer");
        this.substitutions = substitutions;
        this.reducer = reducer;
    }
}

