/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.basic;

import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class EnumConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class type) {
        return type.isEnum();
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (configuration.getChildCount() > 0) {
            throw new ComponentConfigurationException("When configuring a basic element the configuration cannot contain any child elements. Configuration element '" + configuration.getName() + "'.");
        }
        Object retValue = this.fromExpression(configuration, expressionEvaluator);
        if (retValue instanceof String) {
            try {
                retValue = Enum.valueOf(type, (String)retValue);
            }
            catch (RuntimeException e) {
                throw new ComponentConfigurationException("Cannot assign value " + retValue + " to property " + configuration.getName() + " of " + baseType.getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return retValue;
    }
}

