/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.MethodNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavaMethod
implements JavaNode {
    private final MethodNode mth;
    private final JavaClass parent;

    JavaMethod(JavaClass cls, MethodNode m) {
        this.parent = cls;
        this.mth = m;
    }

    @Override
    public String getName() {
        return this.mth.getAlias();
    }

    @Override
    public String getFullName() {
        return this.mth.getMethodInfo().getFullName();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.parent;
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.parent.getTopParentClass();
    }

    public AccessInfo getAccessFlags() {
        return this.mth.getAccessFlags();
    }

    public List<ArgType> getArguments() {
        if (this.mth.getMethodInfo().getArgumentsTypes().isEmpty()) {
            return Collections.emptyList();
        }
        List<RegisterArg> arguments = this.mth.getArguments(false);
        Stream<Object> argTypeStream = arguments == null || arguments.isEmpty() || this.mth.isNoCode() ? this.mth.getMethodInfo().getArgumentsTypes().stream() : arguments.stream().map(RegisterArg::getType);
        return argTypeStream.map(type -> ArgType.tryToResolveClassAlias(this.mth.dex(), type)).collect(Collectors.toList());
    }

    public ArgType getReturnType() {
        ArgType retType = this.mth.getReturnType();
        if (retType == null) {
            retType = this.mth.getMethodInfo().getReturnType();
        }
        return ArgType.tryToResolveClassAlias(this.mth.dex(), retType);
    }

    public boolean isConstructor() {
        return this.mth.getMethodInfo().isConstructor();
    }

    public boolean isClassInit() {
        return this.mth.getMethodInfo().isClassInit();
    }

    @Override
    public int getDecompiledLine() {
        return this.mth.getDecompiledLine();
    }

    public int hashCode() {
        return this.mth.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JavaMethod && this.mth.equals(((JavaMethod)o).mth);
    }

    public String toString() {
        return this.mth.toString();
    }
}

