/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ResourcesLoader;
import jadx.core.codegen.CodeWriter;
import jadx.core.dex.info.ConstStorage;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.CommonBinaryParser;
import jadx.core.xmlgen.ManifestAttributes;
import jadx.core.xmlgen.ParserStream;
import jadx.core.xmlgen.XMLChar;
import jadx.core.xmlgen.XmlDeobf;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryXMLParser
extends CommonBinaryParser {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryXMLParser.class);
    private static final String ANDROID_R_STYLE_CLS = "android.R$style";
    private static final boolean ATTR_NEW_LINE = false;
    private final Map<Integer, String> styleMap = new HashMap<Integer, String>();
    private final Map<Integer, String> resNames;
    private final Map<String, String> nsMap = new HashMap<String, String>();
    private Set<String> nsMapGenerated;
    private final Map<String, String> tagAttrDeobfNames = new HashMap<String, String>();
    private CodeWriter writer;
    private String[] strings;
    private String currentTag = "ERROR";
    private boolean firstElement;
    private ValuesParser valuesParser;
    private boolean isLastEnd = true;
    private boolean isOneLine = true;
    private int namespaceDepth = 0;
    private int[] resourceIds;
    private RootNode rootNode;
    private String appPackageName;

    public BinaryXMLParser(RootNode rootNode) {
        this.rootNode = rootNode;
        try {
            this.readAndroidRStyleClass();
            ConstStorage constStorage = rootNode.getConstValues();
            this.resNames = constStorage.getResourcesNames();
        }
        catch (Exception e) {
            throw new JadxRuntimeException("BinaryXMLParser init error", e);
        }
    }

    private void readAndroidRStyleClass() {
        try {
            Class<?> rStyleCls = Class.forName(ANDROID_R_STYLE_CLS);
            for (Field f : rStyleCls.getFields()) {
                this.styleMap.put(f.getInt(f.getType()), f.getName());
            }
        }
        catch (Exception e) {
            LOG.error("Android R class loading failed", (Throwable)e);
        }
    }

    public synchronized CodeWriter parse(InputStream inputStream) throws IOException {
        this.is = new ParserStream(inputStream);
        if (!this.isBinaryXml()) {
            return ResourcesLoader.loadToCodeWriter(inputStream);
        }
        this.nsMapGenerated = new HashSet<String>();
        this.writer = new CodeWriter();
        this.writer.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.firstElement = true;
        this.decode();
        this.writer.finish();
        return this.writer;
    }

    private boolean isBinaryXml() throws IOException {
        this.is.mark(4);
        int v = this.is.readInt16();
        int h = this.is.readInt16();
        if (v == 3 && h == 8) {
            return true;
        }
        this.is.reset();
        return false;
    }

    void decode() throws IOException {
        int size = this.is.readInt32();
        block10: while (this.is.getPos() < (long)size) {
            int type = this.is.readInt16();
            switch (type) {
                case 0: {
                    continue block10;
                }
                case 1: {
                    this.strings = this.parseStringPoolNoType();
                    this.valuesParser = new ValuesParser(this.rootNode, this.strings, this.resNames);
                    continue block10;
                }
                case 384: {
                    this.parseResourceMap();
                    continue block10;
                }
                case 256: {
                    this.parseNameSpace();
                    continue block10;
                }
                case 260: {
                    this.parseCData();
                    continue block10;
                }
                case 257: {
                    this.parseNameSpaceEnd();
                    continue block10;
                }
                case 258: {
                    this.parseElement();
                    continue block10;
                }
                case 259: {
                    this.parseElementEnd();
                    continue block10;
                }
            }
            if (this.namespaceDepth == 0) {
                return;
            }
            this.die("Type: 0x" + Integer.toHexString(type) + " not yet implemented");
        }
    }

    private void parseResourceMap() throws IOException {
        if (this.is.readInt16() != 8) {
            this.die("Header size of resmap is not 8!");
        }
        int size = this.is.readInt32();
        int len = (size - 8) / 4;
        this.resourceIds = new int[len];
        for (int i = 0; i < len; ++i) {
            this.resourceIds[i] = this.is.readInt32();
        }
    }

    private void parseNameSpace() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("NAMESPACE header is not 0x0010");
        }
        if (this.is.readInt32() != 24) {
            this.die("NAMESPACE header chunk is not 0x18 big");
        }
        int beginLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int beginPrefix = this.is.readInt32();
        int beginURI = this.is.readInt32();
        String nsValue = this.getString(beginPrefix);
        if (!this.nsMap.containsValue(nsValue)) {
            this.nsMap.putIfAbsent(this.getString(beginURI), nsValue);
        }
        ++this.namespaceDepth;
    }

    private void parseNameSpaceEnd() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("NAMESPACE header is not 0x0010");
        }
        if (this.is.readInt32() != 24) {
            this.die("NAMESPACE header chunk is not 0x18 big");
        }
        int endLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int endPrefix = this.is.readInt32();
        int endURI = this.is.readInt32();
        --this.namespaceDepth;
        String nsValue = this.getString(endPrefix);
        if (!this.nsMap.containsValue(nsValue)) {
            this.nsMap.putIfAbsent(this.getString(endURI), nsValue);
        }
    }

    private void parseCData() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("CDATA header is not 0x10");
        }
        if (this.is.readInt32() != 28) {
            this.die("CDATA header chunk is not 0x1C");
        }
        int lineNumber = this.is.readInt32();
        this.is.skip(4L);
        int strIndex = this.is.readInt32();
        String str = this.getString(strIndex);
        if (!this.isLastEnd) {
            this.isLastEnd = true;
            this.writer.add('>');
        }
        this.writer.attachSourceLine(lineNumber);
        String escapedStr = StringUtils.escapeXML(str);
        this.writer.add(escapedStr);
        long size = this.is.readInt16();
        this.is.skip(size - 2L);
    }

    private void parseElement() throws IOException {
        int attributeSize;
        if (this.firstElement) {
            this.firstElement = false;
        } else {
            this.writer.incIndent();
        }
        if (this.is.readInt16() != 16) {
            this.die("ELEMENT HEADER SIZE is not 0x10");
        }
        this.is.readInt32();
        int elementBegLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int startNS = this.is.readInt32();
        int startNSName = this.is.readInt32();
        if (!this.isLastEnd && !"ERROR".equals(this.currentTag)) {
            this.writer.add('>');
        }
        this.isOneLine = true;
        this.isLastEnd = false;
        this.currentTag = this.deobfClassName(this.getString(startNSName));
        this.currentTag = this.getValidTagAttributeName(this.currentTag);
        this.writer.startLine('<').add(this.currentTag);
        this.writer.attachSourceLine(elementBegLineNumber);
        int attributeStart = this.is.readInt16();
        if (attributeStart != 20) {
            this.die("startNS's attributeStart is not 0x14");
        }
        if ((attributeSize = this.is.readInt16()) != 20) {
            this.die("startNS's attributeSize is not 0x14");
        }
        int attributeCount = this.is.readInt16();
        int idIndex = this.is.readInt16();
        int classIndex = this.is.readInt16();
        int styleIndex = this.is.readInt16();
        if ("manifest".equals(this.currentTag) || this.writer.getIndent() == 0) {
            for (Map.Entry<String, String> entry : this.nsMap.entrySet()) {
                String nsValue = entry.getValue();
                this.writer.add(" xmlns");
                if (nsValue != null && !nsValue.trim().isEmpty()) {
                    this.writer.add(':');
                    this.writer.add(nsValue);
                }
                this.writer.add("=\"").add(StringUtils.escapeXML(entry.getKey())).add('\"');
            }
        }
        if (attributeCount != 1) {
            // empty if block
        }
        boolean attrNewLine = false;
        for (int i = 0; i < attributeCount; ++i) {
            this.parseAttribute(i, attrNewLine);
        }
    }

    private void parseAttribute(int i, boolean newLine) throws IOException {
        int attributeNS = this.is.readInt32();
        int attributeName = this.is.readInt32();
        int attributeRawValue = this.is.readInt32();
        int attrValSize = this.is.readInt16();
        if (attrValSize != 8) {
            this.die("attrValSize != 0x08 not supported");
        }
        if (this.is.readInt8() != 0) {
            this.die("res0 is not 0");
        }
        int attrValDataType = this.is.readInt8();
        int attrValData = this.is.readInt32();
        if (newLine) {
            this.writer.startLine().addIndent();
        } else {
            this.writer.add(' ');
        }
        String shortNsName = null;
        if (attributeNS != -1) {
            shortNsName = this.getAttributeNS(attributeNS);
            this.writer.add(shortNsName).add(':');
        }
        String attrName = this.getValidTagAttributeName(this.getAttributeName(attributeName));
        this.writer.add(attrName).add("=\"");
        String decodedAttr = ManifestAttributes.getInstance().decode(attrName, attrValData);
        if (decodedAttr != null) {
            this.memorizePackageName(attrName, decodedAttr);
            if (this.isDeobfCandidateAttr(shortNsName, attrName)) {
                decodedAttr = this.deobfClassName(decodedAttr);
            }
            this.writer.add(StringUtils.escapeXML(decodedAttr));
        } else {
            this.decodeAttribute(attributeNS, attrValDataType, attrValData, shortNsName, attrName);
        }
        this.writer.add('\"');
    }

    private String getAttributeNS(int attributeNS) {
        String attrName;
        String attrUrl = this.getString(attributeNS);
        if (attrUrl == null || attrUrl.isEmpty()) {
            if (BinaryXMLParser.isResInternalId(attributeNS)) {
                return null;
            }
            attrUrl = "http://schemas.android.com/apk/res/android";
        }
        if ((attrName = this.nsMap.get(attrUrl)) == null) {
            attrName = this.generateNameForNS(attrUrl);
        }
        return attrName;
    }

    private String generateNameForNS(String attrUrl) {
        int i = 1;
        while (true) {
            String attrName;
            if (!this.nsMap.containsValue(attrName = "ns" + i) && !this.nsMapGenerated.contains(attrName)) {
                this.nsMapGenerated.add(attrName);
                this.writer.add("xmlns:").add(attrName).add("=\"").add(attrUrl).add("\" ");
                return attrName;
            }
            ++i;
        }
    }

    private String getAttributeName(int id) {
        String str = this.getString(id);
        if (str == null || str.isEmpty()) {
            int resId = this.resourceIds[id];
            str = ValuesParser.getAndroidResMap().get(resId);
            if (str == null) {
                return "NOT_FOUND_0x" + Integer.toHexString(id);
            }
            int typeEnd = str.indexOf(47);
            if (typeEnd != -1) {
                return str.substring(typeEnd + 1);
            }
            return str;
        }
        return str;
    }

    private String getString(int strId) {
        if (0 <= strId && strId < this.strings.length) {
            return this.strings[strId];
        }
        return "NOT_FOUND_STR_0x" + Integer.toHexString(strId);
    }

    private void decodeAttribute(int attributeNS, int attrValDataType, int attrValData, String shortNsName, String attrName) {
        if (attrValDataType == 1) {
            String name = this.styleMap.get(attrValData);
            if (name != null) {
                this.writer.add("@style/").add(name.replace('_', '.'));
            } else {
                String resName = this.resNames.get(attrValData);
                if (resName != null) {
                    this.writer.add('@');
                    if (resName.startsWith("id/")) {
                        this.writer.add('+');
                    }
                    this.writer.add(resName);
                } else {
                    resName = ValuesParser.getAndroidResMap().get(attrValData);
                    if (resName != null) {
                        this.writer.add("@android:").add(resName);
                    } else if (attrValData == 0) {
                        this.writer.add("@null");
                    } else {
                        this.writer.add("0x").add(Integer.toHexString(attrValData));
                    }
                }
            }
        } else {
            String str = this.valuesParser.decodeValue(attrValDataType, attrValData);
            this.memorizePackageName(attrName, str);
            if (this.isDeobfCandidateAttr(shortNsName, attrName)) {
                str = this.deobfClassName(str);
            }
            this.writer.add(str != null ? StringUtils.escapeXML(str) : "null");
        }
    }

    private void parseElementEnd() throws IOException {
        if (this.is.readInt16() != 16) {
            this.die("ELEMENT END header is not 0x10");
        }
        if (this.is.readInt32() != 24) {
            this.die("ELEMENT END header chunk is not 0x18 big");
        }
        int endLineNumber = this.is.readInt32();
        int comment = this.is.readInt32();
        int elementNS = this.is.readInt32();
        int elementNameId = this.is.readInt32();
        String elemName = this.deobfClassName(this.getString(elementNameId));
        if (this.currentTag.equals(elemName = this.getValidTagAttributeName(elemName)) && this.isOneLine && !this.isLastEnd) {
            this.writer.add("/>");
        } else {
            this.writer.startLine("</");
            this.writer.attachSourceLine(endLineNumber);
            this.writer.add(elemName).add('>');
        }
        this.isLastEnd = true;
        if (this.writer.getIndent() != 0) {
            this.writer.decIndent();
        }
    }

    private String getValidTagAttributeName(String originalName) {
        String generated;
        if (XMLChar.isValidName(originalName)) {
            return originalName;
        }
        if (this.tagAttrDeobfNames.containsKey(originalName)) {
            return this.tagAttrDeobfNames.get(originalName);
        }
        while (this.tagAttrDeobfNames.containsValue(generated = BinaryXMLParser.generateTagAttrName())) {
        }
        this.tagAttrDeobfNames.put(originalName, generated);
        return generated;
    }

    private static String generateTagAttrName() {
        int length = 6;
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 6; ++i) {
            sb.append((char)(r.nextInt(26) + 97));
        }
        return sb.toString();
    }

    private String deobfClassName(String className) {
        String newName = XmlDeobf.deobfClassName(this.rootNode, className, this.appPackageName);
        if (newName != null) {
            return newName;
        }
        return className;
    }

    private boolean isDeobfCandidateAttr(String shortNsName, String attrName) {
        if (shortNsName == null) {
            return false;
        }
        String fullName = shortNsName + ':' + attrName;
        return "android:name".equals(fullName);
    }

    private void memorizePackageName(String attrName, String attrValue) {
        if ("manifest".equals(this.currentTag) && "package".equals(attrName)) {
            this.appPackageName = attrValue;
        }
    }
}

