/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageMouseClickListener;
import hu.kazocsaba.imageviewer.ImageMouseEvent;
import hu.kazocsaba.imageviewer.ImageMouseMotionListener;
import hu.kazocsaba.imageviewer.ImageViewer;
import hu.kazocsaba.imageviewer.ResizeStrategy;
import java.applet.Applet;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

class ImageComponent
extends JComponent {
    private ResizeStrategy resizeStrategy = ResizeStrategy.SHRINK_TO_FIT;
    private BufferedImage image;
    private boolean pixelatedZoom = false;
    private Object interpolationType = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
    private double zoomFactor = 1.0;
    private final List<ImageMouseMotionListener> moveListeners = new ArrayList<ImageMouseMotionListener>(4);
    private final List<ImageMouseClickListener> clickListeners = new ArrayList<ImageMouseClickListener>(4);
    private final MouseEventTranslator mouseEventTranslator = new MouseEventTranslator();
    private final PaintManager paintManager = new PaintManager();
    private Rescroller rescroller = new Rescroller();
    private final PropertyChangeSupport propertyChangeSupport;
    private final ImageViewer viewer;

    public ImageComponent(ImageViewer viewer, PropertyChangeSupport propertyChangeSupport) {
        this.viewer = viewer;
        this.propertyChangeSupport = propertyChangeSupport;
        this.mouseEventTranslator.register(this);
        this.setOpaque(true);
        viewer.getScrollPane().getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ImageComponent.this.hasSize()) {
                    ImageComponent.this.mouseEventTranslator.correctionalFire();
                }
            }
        });
    }

    private boolean hasSize() {
        return this.getWidth() > 0 && this.getHeight() > 0;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addImageMouseMoveListener(ImageMouseMotionListener l) {
        if (l != null) {
            this.moveListeners.add(l);
        }
    }

    public void removeImageMouseMoveListener(ImageMouseMotionListener l) {
        if (l != null) {
            this.moveListeners.remove(l);
        }
    }

    public void addImageMouseClickListener(ImageMouseClickListener l) {
        if (l != null) {
            this.clickListeners.add(l);
        }
    }

    public void removeImageMouseClickListener(ImageMouseClickListener l) {
        if (l != null) {
            this.clickListeners.remove(l);
        }
    }

    public void setImage(BufferedImage newImage) {
        BufferedImage oldImage = this.image;
        this.image = newImage;
        this.paintManager.notifyChanged();
        if (oldImage != newImage && (oldImage == null || newImage == null || oldImage.getWidth() != newImage.getWidth() || oldImage.getHeight() != newImage.getHeight())) {
            this.revalidate();
        }
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("image", oldImage, newImage);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void resizeNow() {
        Container c;
        this.invalidate();
        Container root = null;
        for (c = this; c != null; c = c.getParent()) {
            if (!c.isDisplayable() || c instanceof CellRendererPane) {
                return;
            }
            if (!c.isValidateRoot()) continue;
            root = c;
            break;
        }
        if (root == null) {
            return;
        }
        while (c != null) {
            if (!c.isDisplayable() || !c.isVisible()) {
                return;
            }
            if (c instanceof Window || c instanceof Applet) break;
            c = c.getParent();
        }
        if (c == null) {
            return;
        }
        root.validate();
        this.repaint();
    }

    public void setResizeStrategy(ResizeStrategy resizeStrategy) {
        if (resizeStrategy == this.resizeStrategy) {
            return;
        }
        this.rescroller.prepare();
        ResizeStrategy oldResizeStrategy = this.resizeStrategy;
        this.resizeStrategy = resizeStrategy;
        boolean canRescroll = this.viewer.getSynchronizer().resizeStrategyChangedCanIRescroll(this.viewer);
        this.resizeNow();
        if (canRescroll) {
            this.rescroller.rescroll();
            this.viewer.getSynchronizer().doneRescrolling(this.viewer);
        }
        this.propertyChangeSupport.firePropertyChange("resizeStrategy", (Object)oldResizeStrategy, (Object)resizeStrategy);
    }

    public ResizeStrategy getResizeStrategy() {
        return this.resizeStrategy;
    }

    public void setInterpolationType(Object type) {
        if (this.interpolationType == type) {
            return;
        }
        if (type != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR && type != RenderingHints.VALUE_INTERPOLATION_BILINEAR && type != RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            throw new IllegalArgumentException("Invalid interpolation type; use one of the RenderingHints constants");
        }
        Object old = this.interpolationType;
        this.interpolationType = type;
        this.viewer.getSynchronizer().interpolationTypeChanged(this.viewer);
        this.paintManager.notifyChanged();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("interpolationType", old, type);
    }

    public Object getInterpolationType() {
        return this.interpolationType;
    }

    public void setPixelatedZoom(boolean pixelatedZoom) {
        if (pixelatedZoom == this.pixelatedZoom) {
            return;
        }
        this.pixelatedZoom = pixelatedZoom;
        this.viewer.getSynchronizer().pixelatedZoomChanged(this.viewer);
        this.paintManager.notifyChanged();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("pixelatedZoom", !pixelatedZoom, pixelatedZoom);
    }

    public boolean isPixelatedZoom() {
        return this.pixelatedZoom;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double newZoomFactor) {
        if (this.zoomFactor == newZoomFactor) {
            return;
        }
        if (newZoomFactor <= 0.0 || Double.isInfinite(newZoomFactor) || Double.isNaN(newZoomFactor)) {
            throw new IllegalArgumentException("Invalid zoom factor: " + newZoomFactor);
        }
        if (this.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM) {
            this.rescroller.prepare();
        }
        double oldZoomFactor = this.zoomFactor;
        this.zoomFactor = newZoomFactor;
        boolean canRescroll = this.viewer.getSynchronizer().zoomFactorChangedCanIRescroll(this.viewer);
        if (this.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM) {
            this.resizeNow();
            if (canRescroll) {
                this.rescroller.rescroll();
                this.viewer.getSynchronizer().doneRescrolling(this.viewer);
            }
        } else if (canRescroll) {
            this.viewer.getSynchronizer().doneRescrolling(this.viewer);
        }
        this.propertyChangeSupport.firePropertyChange("zoomFactor", oldZoomFactor, newZoomFactor);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return new Dimension();
        }
        if (this.resizeStrategy == ResizeStrategy.CUSTOM_ZOOM) {
            return new Dimension((int)Math.ceil((double)this.image.getWidth() * this.zoomFactor), (int)Math.ceil((double)this.image.getHeight() * this.zoomFactor));
        }
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    public Point pointToPixel(Point p) {
        return this.pointToPixel(p, true);
    }

    public Point pointToPixel(Point p, boolean clipToImage) {
        Point2D.Double fp = new Point2D.Double((double)p.x + 0.5, (double)p.y + 0.5);
        try {
            this.getImageTransform().inverseTransform(fp, fp);
        }
        catch (NoninvertibleTransformException ex) {
            throw new Error("Image transformation not invertible");
        }
        p.x = (int)Math.floor(fp.x);
        p.y = (int)Math.floor(fp.y);
        if (clipToImage && (p.x < 0 || p.y < 0 || p.x >= this.image.getWidth() || p.y >= this.image.getHeight())) {
            return null;
        }
        return p;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintManager.paintComponent(g);
    }

    public AffineTransform getImageTransform() {
        double currentZoom;
        if (this.getImage() == null) {
            throw new IllegalStateException("No image");
        }
        if (!this.hasSize()) {
            throw new IllegalStateException("Viewer size is zero");
        }
        switch (this.resizeStrategy) {
            case NO_RESIZE: {
                currentZoom = 1.0;
                break;
            }
            case SHRINK_TO_FIT: {
                currentZoom = Math.min(this.getSizeRatio(), 1.0);
                break;
            }
            case RESIZE_TO_FIT: {
                currentZoom = this.getSizeRatio();
                break;
            }
            case CUSTOM_ZOOM: {
                currentZoom = this.zoomFactor;
                break;
            }
            default: {
                throw new Error("Unhandled resize strategy");
            }
        }
        AffineTransform tr = new AffineTransform();
        tr.setToTranslation(((double)this.getWidth() - (double)this.image.getWidth() * currentZoom) / 2.0, ((double)this.getHeight() - (double)this.image.getHeight() * currentZoom) / 2.0);
        tr.scale(currentZoom, currentZoom);
        return tr;
    }

    private double getSizeRatio() {
        return Math.min((double)this.getWidth() / (double)this.image.getWidth(), (double)this.getHeight() / (double)this.image.getHeight());
    }

    private class PaintManager {
        BufferedImage cachedImage = null;
        boolean cachedImageChanged = false;
        AffineTransform cachedTransform;

        private PaintManager() {
        }

        private void doPaint(Graphics2D gg, AffineTransform imageTransform) {
            gg.setColor(ImageComponent.this.getBackground());
            gg.fillRect(0, 0, ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
            gg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (ImageComponent.this.pixelatedZoom && imageTransform.getScaleX() >= 1.0) {
                gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else {
                gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, ImageComponent.this.interpolationType);
            }
            gg.drawImage(ImageComponent.this.image, imageTransform, ImageComponent.this);
        }

        private void ensureCachedValid(AffineTransform imageTransform) {
            boolean cacheValid;
            if (this.cachedImage == null || this.cachedImage.getWidth() < ImageComponent.this.getWidth() || this.cachedImage.getHeight() < ImageComponent.this.getHeight()) {
                this.cachedImage = ImageComponent.this.getGraphicsConfiguration().createCompatibleImage(ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
                cacheValid = false;
            } else {
                boolean bl = cacheValid = this.cachedTransform.equals(imageTransform) && !this.cachedImageChanged;
            }
            if (!cacheValid) {
                Graphics2D gg = this.cachedImage.createGraphics();
                this.doPaint(gg, imageTransform);
                gg.dispose();
                this.cachedImageChanged = false;
                this.cachedTransform = new AffineTransform(imageTransform);
            }
        }

        public void notifyChanged() {
            this.cachedImageChanged = true;
        }

        public void paintComponent(Graphics g) {
            if (ImageComponent.this.image == null) {
                Graphics2D gg = (Graphics2D)g.create();
                gg.setColor(ImageComponent.this.getBackground());
                gg.fillRect(0, 0, ImageComponent.this.getWidth(), ImageComponent.this.getHeight());
                gg.dispose();
                return;
            }
            AffineTransform imageTransform = ImageComponent.this.getImageTransform();
            if (imageTransform.getScaleX() < 1.0 && ImageComponent.this.interpolationType != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                this.ensureCachedValid(imageTransform);
                g.drawImage(this.cachedImage, 0, 0, ImageComponent.this);
            } else {
                Graphics2D gg = (Graphics2D)g.create();
                this.doPaint(gg, imageTransform);
                gg.dispose();
            }
        }
    }

    private class MouseEventTranslator
    implements MouseInputListener,
    PropertyChangeListener {
        private boolean on = false;
        private Point lastPosition = null;

        private MouseEventTranslator() {
        }

        private void register(ImageComponent ic) {
            ic.addMouseListener(this);
            ic.addMouseMotionListener(this);
            ic.propertyChangeSupport.addPropertyChangeListener(this);
            ic.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    MouseEventTranslator.this.correctionalFire();
                }
            });
        }

        private void handleMouseAt(Point position, MouseEvent event) {
            if (ImageComponent.this.image == null) {
                if (this.on) {
                    this.on = false;
                    this.fireMouseExit();
                }
            } else {
                if (position != null) {
                    position = ImageComponent.this.pointToPixel(position);
                }
                if (position == null) {
                    if (this.on) {
                        this.on = false;
                        this.fireMouseExit();
                    }
                } else {
                    if (!this.on) {
                        this.on = true;
                        this.lastPosition = null;
                        this.fireMouseEnter(position.x, position.y, event);
                    }
                    if (!position.equals(this.lastPosition)) {
                        this.lastPosition = position;
                        this.fireMouseAtPixel(position.x, position.y, event);
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ImageComponent.this.image == null || !this.on) {
                return;
            }
            Point p = ImageComponent.this.pointToPixel(e.getPoint());
            if (p != null) {
                this.fireMouseClickedAtPixel(p.x, p.y, e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Point p;
            if (ImageComponent.this.image != null && (p = ImageComponent.this.pointToPixel(e.getPoint())) != null) {
                this.on = true;
                this.fireMouseEnter(p.x, p.y, e);
                this.fireMouseAtPixel(p.x, p.y, e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.on) {
                this.on = false;
                this.fireMouseExit();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleMouseAt(e.getPoint(), e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ImageComponent.this.image == null) {
                return;
            }
            Point p = ImageComponent.this.pointToPixel(e.getPoint(), false);
            this.fireMouseDrag(p.x, p.y, e);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("image".equals(evt.getPropertyName()) || "resizeStrategy".equals(evt.getPropertyName()) || ImageComponent.this.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM && "zoomFactor".equals(evt.getPropertyName())) {
                this.correctionalFire();
            }
        }

        private void correctionalFire() {
            this.handleMouseAt(ImageComponent.this.getParent().getMousePosition(true), null);
        }

        private void fireMouseAtPixel(int x, int y, MouseEvent ev) {
            ImageMouseEvent e = null;
            for (ImageMouseMotionListener imageMouseMoveListener : ImageComponent.this.moveListeners) {
                if (e == null) {
                    e = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, x, y, ev);
                }
                imageMouseMoveListener.mouseMoved(e);
            }
        }

        private void fireMouseClickedAtPixel(int x, int y, MouseEvent ev) {
            ImageMouseEvent e = null;
            for (ImageMouseClickListener imageMouseClickListener : ImageComponent.this.clickListeners) {
                if (e == null) {
                    e = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, x, y, ev);
                }
                imageMouseClickListener.mouseClicked(e);
            }
        }

        private void fireMouseEnter(int x, int y, MouseEvent ev) {
            ImageMouseEvent e = null;
            for (ImageMouseMotionListener imageMouseMoveListener : ImageComponent.this.moveListeners) {
                if (e == null) {
                    e = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, x, y, ev);
                }
                imageMouseMoveListener.mouseEntered(e);
            }
        }

        private void fireMouseExit() {
            ImageMouseEvent e = null;
            for (ImageMouseMotionListener imageMouseMoveListener : ImageComponent.this.moveListeners) {
                if (e == null) {
                    e = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, -1, -1, null);
                }
                imageMouseMoveListener.mouseExited(e);
            }
        }

        private void fireMouseDrag(int x, int y, MouseEvent ev) {
            ImageMouseEvent e = null;
            for (ImageMouseMotionListener imageMouseMoveListener : ImageComponent.this.moveListeners) {
                if (e == null) {
                    e = new ImageMouseEvent(ImageComponent.this.viewer, ImageComponent.this.image, x, y, ev);
                }
                imageMouseMoveListener.mouseDragged(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class Rescroller {
        private Point2D preparedCenter = null;

        Rescroller() {
        }

        void prepare() {
            if (ImageComponent.this.image != null && ImageComponent.this.hasSize()) {
                Rectangle viewRect = ImageComponent.this.viewer.getScrollPane().getViewport().getViewRect();
                this.preparedCenter = new Point2D.Double(viewRect.getCenterX(), viewRect.getCenterY());
                try {
                    ImageComponent.this.getImageTransform().inverseTransform(this.preparedCenter, this.preparedCenter);
                }
                catch (NoninvertibleTransformException e) {
                    throw new Error(e);
                }
            }
        }

        void rescroll() {
            if (this.preparedCenter != null) {
                Dimension viewSize = ImageComponent.this.viewer.getScrollPane().getViewport().getExtentSize();
                ImageComponent.this.getImageTransform().transform(this.preparedCenter, this.preparedCenter);
                Rectangle view = new Rectangle((int)Math.round(this.preparedCenter.getX() - (double)viewSize.width / 2.0), (int)Math.round(this.preparedCenter.getY() - (double)viewSize.height / 2.0), viewSize.width, viewSize.height);
                this.preparedCenter = null;
                ImageComponent.this.scrollRectToVisible(view);
            }
        }
    }
}

