/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SupportedGroups;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerNameList;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;

class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSessionImpl sslSession = null;
    protected BCSNIServerName matchedSNIServerName = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager provTlsManager) throws SSLException {
        super(provTlsManager.getContextData().getCrypto());
        this.manager = provTlsManager;
        this.sslParameters = provTlsManager.getProvSSLParameters();
        if (!provTlsManager.getEnableSessionCreation()) {
            throw new SSLException("Session resumption not implemented yet and session creation is disabled");
        }
    }

    protected int getMaximumNegotiableCurveBits() {
        return SupportedGroups.getServerMaximumNegotiableCurveBits(this.manager.getContext().isFips(), this.clientSupportedGroups);
    }

    protected int getMaximumNegotiableFiniteFieldBits() {
        int n = SupportedGroups.getServerMaximumNegotiableFiniteFieldBits(this.manager.getContext().isFips(), this.clientSupportedGroups);
        return n >= provEphemeralDHKeySize ? n : 0;
    }

    protected ProtocolVersion getMaximumVersion() {
        return this.manager.getContext().getMaximumVersion(this.sslParameters.getProtocols());
    }

    protected boolean selectCipherSuite(int n) throws IOException {
        if (!this.selectCredentials(n)) {
            return false;
        }
        this.manager.getContext().validateNegotiatedCipherSuite(n);
        return super.selectCipherSuite(n);
    }

    protected int selectCurve(int n) {
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultCurve(n);
        }
        boolean bl = this.manager.getContext().isFips();
        return SupportedGroups.getServerSelectedCurve(bl, n, this.clientSupportedGroups);
    }

    protected int selectDefaultCurve(int n) {
        return SupportedGroups.getServerDefaultCurve(this.manager.getContext().isFips(), n);
    }

    protected TlsDHConfig selectDefaultDHConfig(int n) {
        return SupportedGroups.getServerDefaultDHConfig(this.manager.getContext().isFips(), n);
    }

    protected TlsDHConfig selectDHConfig(int n) {
        n = Math.max(n, provEphemeralDHKeySize);
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultDHConfig(n);
        }
        boolean bl = this.manager.getContext().isFips();
        int n2 = SupportedGroups.getServerSelectedFiniteField(bl, n, this.clientSupportedGroups);
        return TlsDHUtils.createNamedDHConfig(n2);
    }

    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public TlsCredentials getCredentials() throws IOException {
        return this.credentials;
    }

    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    protected short[] getCompressionMethods() {
        short[] sArray;
        if (this.manager.getContext().isFips()) {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = 0;
        } else {
            sArray = super.getCompressionMethods();
        }
        return sArray;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        boolean bl;
        boolean bl2 = bl = this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
        if (!bl) {
            return null;
        }
        short[] sArray = new short[]{1, 2, 64};
        Vector vector = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            vector = JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
        }
        Vector<X500Name> vector2 = new Vector<X500Name>();
        X509TrustManager x509TrustManager = this.manager.getContextData().getTrustManager();
        if (x509TrustManager != null) {
            for (X509Certificate x509Certificate : x509TrustManager.getAcceptedIssuers()) {
                vector2.addElement(X500Name.getInstance((Object)x509Certificate.getSubjectX500Principal().getEncoded()));
            }
        }
        return new CertificateRequest(sArray, vector, vector2);
    }

    public int getSelectedCipherSuite() throws IOException {
        this.keyManagerMissCache = new HashSet<String>();
        int n = super.getSelectedCipherSuite();
        LOG.fine("Server selected cipher suite: " + this.manager.getContext().getCipherSuiteString(n));
        this.keyManagerMissCache = null;
        return n;
    }

    public Hashtable getServerExtensions() throws IOException {
        super.getServerExtensions();
        if (this.matchedSNIServerName != null) {
            this.checkServerExtensions().put(TlsExtensionsUtils.EXT_server_name, TlsExtensionsUtils.createEmptyExtensionData());
        }
        return this.serverExtensions;
    }

    public TlsSession getSessionToResume(byte[] byArray) {
        TlsSession tlsSession;
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
        this.sslSession = provSSLSessionContext.getSessionImpl(byArray);
        if (this.sslSession != null && (tlsSession = this.sslSession.getTlsSession()) != null) {
            return tlsSession;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String string2 = JsseUtils.getAlertLogMessage("Server raised", s, s2);
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            LOG.log(level, string2, throwable);
        }
    }

    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Server received", s, s2);
            LOG.log(level, string);
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        String[] stringArray = this.sslParameters.getProtocols();
        if (stringArray != null && stringArray.length > 0) {
            for (ProtocolVersion protocolVersion = this.clientVersion; protocolVersion != null; protocolVersion = protocolVersion.getPreviousVersion()) {
                String string = this.manager.getContext().getProtocolString(protocolVersion);
                if (string == null || !JsseUtils.contains(stringArray, string)) continue;
                LOG.fine("Server selected protocol version: " + protocolVersion);
                this.serverVersion = protocolVersion;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    public void notifyClientCertificate(Certificate certificate) throws IOException {
        boolean bl;
        assert (this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth());
        boolean bl2 = bl = certificate == null || certificate.isEmpty();
        if (bl) {
            if (this.sslParameters.getNeedClientAuth()) {
                throw new TlsFatalAlert(40);
            }
        } else {
            short s;
            String string;
            X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(this.manager.getContextData().getCrypto(), certificate);
            if (!this.manager.isClientTrusted(x509CertificateArray, string = JsseUtils.getAuthTypeClient(s = certificate.getCertificateAt(0).getClientCertificateType()))) {
                throw new TlsFatalAlert(42);
            }
        }
    }

    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        TlsSession tlsSession = this.context.getSession();
        if (this.sslSession == null || this.sslSession.getTlsSession() != tlsSession) {
            this.sslSession = this.manager.getContextData().getServerSessionContext().reportSession(tlsSession, null, -1);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    public void processClientExtensions(Hashtable hashtable) throws IOException {
        ServerNameList serverNameList;
        Collection<BCSNIMatcher> collection;
        super.processClientExtensions(hashtable);
        if (hashtable != null && (collection = this.manager.getProvSSLParameters().getSNIMatchers()) != null && !collection.isEmpty() && (serverNameList = TlsExtensionsUtils.getServerNameExtension(hashtable)) != null) {
            this.matchedSNIServerName = JsseUtils.findMatchingSNIServerName(serverNameList, collection);
            if (this.matchedSNIServerName == null) {
                throw new TlsFatalAlert(112);
            }
        }
    }

    protected boolean selectCredentials(int n) throws IOException {
        this.credentials = null;
        int n2 = TlsUtils.getKeyExchangeAlgorithm(n);
        switch (n2) {
            case 11: 
            case 20: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            default: {
                return false;
            }
        }
        X509KeyManager x509KeyManager = this.manager.getContextData().getKeyManager();
        if (x509KeyManager == null) {
            return false;
        }
        String string = JsseUtils.getAuthTypeServer(n2);
        if (this.keyManagerMissCache.contains(string)) {
            return false;
        }
        Principal[] principalArray = null;
        Socket socket = null;
        String string2 = x509KeyManager.chooseServerAlias(string, principalArray, socket);
        if (string2 == null) {
            this.keyManagerMissCache.add(string);
            return false;
        }
        TlsCrypto tlsCrypto = this.getCrypto();
        if (!(tlsCrypto instanceof JcaTlsCrypto)) {
            throw new UnsupportedOperationException();
        }
        PrivateKey privateKey = x509KeyManager.getPrivateKey(string2);
        Certificate certificate = JsseUtils.getCertificateMessage(tlsCrypto, x509KeyManager.getCertificateChain(string2));
        if (privateKey == null || !JsseUtils.isUsableKeyForServer(n2, privateKey) || certificate.isEmpty()) {
            this.keyManagerMissCache.add(string);
            return false;
        }
        switch (n2) {
            case 7: 
            case 9: 
            case 16: 
            case 18: {
                this.credentials = new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)tlsCrypto, certificate, privateKey);
                return true;
            }
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                short s = TlsUtils.getSignatureAlgorithm(n2);
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.supportedSignatureAlgorithms, s);
                this.credentials = new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (JcaTlsCrypto)tlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
                return true;
            }
            case 1: {
                this.credentials = new JceDefaultTlsCredentialedDecryptor((JcaTlsCrypto)tlsCrypto, certificate, privateKey);
                return true;
            }
        }
        return false;
    }
}

