/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import com.google.common.annotations.VisibleForTesting;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.execution.WorkerLoop;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.counter.LongCounter;

@JRubyClass(name={"FilterDelegator"})
public final class FilterDelegatorExt
extends AbstractFilterDelegatorExt {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_METHOD_NAME = "multi_filter";
    private RubyClass filterClass;
    private IRubyObject filter;
    private DynamicMethod filterMethod;
    private boolean flushes;

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject filter, IRubyObject id) {
        this.id = (RubyString)id;
        this.filter = filter;
        this.filterClass = filter.getSingletonClass().getRealClass();
        this.filterMethod = this.filterClass.searchMethod(FILTER_METHOD_NAME);
        AbstractNamespacedMetricExt namespacedMetric = (AbstractNamespacedMetricExt)filter.callMethod(context, "metric");
        this.initMetrics(this.id.asJavaString(), namespacedMetric);
        this.flushes = filter.respondsTo("flush");
        return this;
    }

    @VisibleForTesting
    public FilterDelegatorExt initForTesting(IRubyObject filter) {
        this.eventMetricOut = LongCounter.DUMMY_COUNTER;
        this.eventMetricIn = LongCounter.DUMMY_COUNTER;
        this.eventMetricTime = LongCounter.DUMMY_COUNTER;
        this.filter = filter;
        this.filterMethod = filter.getMetaClass().searchMethod(FILTER_METHOD_NAME);
        this.flushes = filter.respondsTo("flush");
        return this;
    }

    public FilterDelegatorExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @Override
    protected void doRegister(ThreadContext context) {
        this.filter.callMethod(context, "register");
    }

    @Override
    protected IRubyObject closeImpl(ThreadContext context) {
        return this.filter.callMethod(context, "close");
    }

    @Override
    protected IRubyObject doCloseImpl(ThreadContext context) {
        return this.filter.callMethod(context, "do_close");
    }

    @Override
    protected IRubyObject doStopImpl(ThreadContext context) {
        return this.filter.callMethod(context, "do_stop");
    }

    @Override
    protected IRubyObject reloadable(ThreadContext context) {
        return this.filter.callMethod(context, "reloadable?");
    }

    @Override
    protected IRubyObject getConcurrency(ThreadContext context) {
        return this.filter.callMethod(context, "threadsafe?");
    }

    @Override
    protected IRubyObject getConfigName(ThreadContext context) {
        return this.filterClass.callMethod(context, "config_name");
    }

    @Override
    protected RubyArray doMultiFilter(RubyArray batch) {
        return (RubyArray)this.filterMethod.call(WorkerLoop.THREAD_CONTEXT.get(), this.filter, (RubyModule)this.filterClass, FILTER_METHOD_NAME, (IRubyObject)batch);
    }

    @Override
    protected IRubyObject doFlush(ThreadContext context, RubyHash options) {
        return this.filter.callMethod(context, "flush", (IRubyObject)options);
    }

    @Override
    protected boolean getHasFlush() {
        return this.flushes;
    }

    @Override
    protected boolean getPeriodicFlush() {
        return this.filter.callMethod(RubyUtil.RUBY.getCurrentContext(), "periodic_flush").isTrue();
    }
}

