/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.logstash.Timestamp;
import org.logstash.ext.JrubyTimestampExtLibrary;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.metrics.gauge.RubyTimeStampGauge;
import org.logstash.instrument.witness.MetricSerializer;
import org.logstash.instrument.witness.SerializableWitness;
import org.logstash.instrument.witness.pipeline.ErrorWitness;

@JsonSerialize(using=Serializer.class)
public final class ReloadWitness
implements SerializableWitness {
    private final LongCounter success = new LongCounter("successes");
    private final LongCounter failure = new LongCounter("failures");
    private final ErrorWitness lastError = new ErrorWitness();
    private final RubyTimeStampGauge lastSuccessTimestamp = new RubyTimeStampGauge("last_success_timestamp");
    private final RubyTimeStampGauge lastFailureTimestamp = new RubyTimeStampGauge("last_failure_timestamp");
    private final Snitch snitch = new Snitch(this);
    private static final String KEY = "reloads";

    public ErrorWitness error() {
        return this.lastError;
    }

    public void failure() {
        this.failure.increment();
    }

    public void failures(long count) {
        this.failure.increment(count);
    }

    public void success() {
        this.success.increment();
    }

    public void successes(long count) {
        this.success.increment(count);
    }

    public Snitch snitch() {
        return this.snitch;
    }

    @Deprecated
    public void lastSuccessTimestamp(JrubyTimestampExtLibrary.RubyTimestamp timestamp) {
        this.lastSuccessTimestamp.set(timestamp);
    }

    @Deprecated
    public void lastFailureTimestamp(JrubyTimestampExtLibrary.RubyTimestamp timestamp) {
        this.lastFailureTimestamp.set(timestamp);
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen, provider);
    }

    public static class Snitch {
        private final ReloadWitness witness;

        Snitch(ReloadWitness witness) {
            this.witness = witness;
        }

        public long successes() {
            return this.witness.success.getValue();
        }

        public long failures() {
            return this.witness.failure.getValue();
        }

        @Deprecated
        public Timestamp lastSuccessTimestamp() {
            return this.witness.lastSuccessTimestamp.getValue();
        }

        @Deprecated
        public Timestamp lastFailureTimestamp() {
            return this.witness.lastFailureTimestamp.getValue();
        }
    }

    public static final class Serializer
    extends StdSerializer<ReloadWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(ReloadWitness.class);
        }

        protected Serializer(Class<ReloadWitness> t) {
            super(t);
        }

        public void serialize(ReloadWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen, provider);
            gen.writeEndObject();
        }

        static void innerSerialize(ReloadWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObjectFieldStart(ReloadWitness.KEY);
            witness.lastError.genJson(gen, provider);
            MetricSerializer<Metric<Long>> longSerializer = MetricSerializer.Get.longSerializer(gen);
            MetricSerializer<RubyTimeStampGauge> timestampSerializer = MetricSerializer.Get.timestampSerializer(gen);
            longSerializer.serialize(witness.success);
            timestampSerializer.serialize(witness.lastSuccessTimestamp);
            timestampSerializer.serialize(witness.lastFailureTimestamp);
            longSerializer.serialize(witness.failure);
            gen.writeEndObject();
        }
    }
}

