/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.aaa;

import java.security.Principal;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.Netshot;
import org.hibernate.annotations.NaturalId;
import org.jasypt.util.password.BasicPasswordEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="\"user\"")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class User
implements Principal {
    private static Logger logger = LoggerFactory.getLogger(User.class);
    public static final int LEVEL_READONLY = 10;
    public static final int LEVEL_READWRITE = 100;
    public static final int LEVEL_EXECUTEREADWRITE = 500;
    public static final int LEVEL_ADMIN = 1000;
    public static int MAX_IDLE_TIME;
    private String serverVersion = "0.14.0";
    private static BasicPasswordEncryptor passwordEncryptor;
    private long id;
    private boolean local;
    private String hashedPassword;
    private String username;
    private int level = 10;

    protected User() {
    }

    public User(String username, boolean local, String password) {
        this.username = username;
        this.local = local;
        this.setPassword(password);
    }

    public User(String name, int level) {
        this.username = name;
        this.level = level;
        this.local = false;
    }

    @Id
    @GeneratedValue
    @XmlElement
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @XmlElement
    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public void setHashedPassword(String hashedPassword) {
        this.hashedPassword = hashedPassword;
    }

    public void setPassword(String password) {
        this.setHashedPassword(this.hash(password));
    }

    public boolean checkPassword(String password) {
        return passwordEncryptor.checkPassword(password, this.hashedPassword);
    }

    private String hash(String password) {
        return passwordEncryptor.encryptPassword(password);
    }

    @XmlElement
    @NaturalId(mutable=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    @Transient
    public String getName() {
        return this.username;
    }

    @XmlElement
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @XmlElement
    @Transient
    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    @Transient
    @XmlElement
    public int getMaxIdleTimout() {
        return MAX_IDLE_TIME;
    }

    static {
        passwordEncryptor = new BasicPasswordEncryptor();
        try {
            MAX_IDLE_TIME = Integer.parseInt(Netshot.getConfig("netshot.aaa.maxidletime", "1800"));
            if (MAX_IDLE_TIME < 30) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            MAX_IDLE_TIME = 1800;
            logger.error("Invalid value for AAA max idle timeout (netshot.aaa.maxidletime), using {}s.", (Object)MAX_IDLE_TIME);
        }
    }
}

