/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.PhysicalAddress;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NetworkInterface {
    @Id
    @GeneratedValue
    private long id;
    @ManyToOne
    protected Device device;
    protected String interfaceName;
    @ElementCollection(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    protected Set<Network4Address> ip4Addresses = new HashSet<Network4Address>();
    @ElementCollection(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    protected Set<Network6Address> ip6Addresses = new HashSet<Network6Address>();
    @Embedded
    protected PhysicalAddress physicalAddress = new PhysicalAddress(0L);
    protected String vrfInstance;
    protected String virtualDevice;
    protected String description;
    protected boolean enabled;
    protected boolean level3;

    protected NetworkInterface() {
    }

    public NetworkInterface(Device device, String interfaceName, String virtualDevice, String vrfInstance, boolean enabled, boolean level3, String description) {
        this.device = device;
        this.interfaceName = interfaceName == null ? "" : interfaceName;
        this.vrfInstance = vrfInstance == null ? "" : vrfInstance;
        this.virtualDevice = virtualDevice == null ? "" : virtualDevice;
        this.enabled = enabled;
        this.level3 = level3;
        this.description = description;
    }

    @XmlElement
    public long getId() {
        return this.id;
    }

    @XmlElement
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @XmlElement
    public Set<Network4Address> getIp4Addresses() {
        return this.ip4Addresses;
    }

    @XmlElement
    public Set<Network6Address> getIp6Addresses() {
        return this.ip6Addresses;
    }

    public List<NetworkAddress> getIpAddresses() {
        ArrayList<NetworkAddress> ipAddresses = new ArrayList<NetworkAddress>();
        ipAddresses.addAll(this.ip4Addresses);
        ipAddresses.addAll(this.ip6Addresses);
        return ipAddresses;
    }

    public void addIpAddress(NetworkAddress address) {
        if (address.getPrefixLength() == 32 && address instanceof Network4Address) {
            for (Network4Address ip : this.ip4Addresses) {
                if (!ip.contains((Network4Address)address)) continue;
                ((Network4Address)address).setPrefixLength(ip.getPrefixLength());
                if (ip.getAddressUsage() != NetworkAddress.AddressUsage.SECONDARY) break;
                if (address.getAddressUsage() == NetworkAddress.AddressUsage.HSRP) {
                    address.setAddressUsage(NetworkAddress.AddressUsage.SECONDARYHSRP);
                    break;
                }
                if (address.getAddressUsage() != NetworkAddress.AddressUsage.VRRP) break;
                address.setAddressUsage(NetworkAddress.AddressUsage.SECONDARYVRRP);
                break;
            }
        } else if (address.getPrefixLength() == 128 && address instanceof Network6Address) {
            for (Network6Address ip : this.ip6Addresses) {
                if (!ip.contains((Network6Address)address)) continue;
                ((Network6Address)address).setPrefixLength(ip.getPrefixLength());
                break;
            }
        }
        if (address instanceof Network4Address) {
            this.ip4Addresses.add((Network4Address)address);
        } else {
            this.ip6Addresses.add((Network6Address)address);
        }
    }

    @XmlElement
    public String getVrfInstance() {
        return this.vrfInstance;
    }

    @XmlElement
    public boolean isEnabled() {
        return this.enabled;
    }

    @XmlElement
    public boolean isLevel3() {
        return this.level3;
    }

    @XmlElement
    public String getMacAddress() {
        return this.physicalAddress.toString();
    }

    public PhysicalAddress getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(PhysicalAddress physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    @XmlElement
    public String getVirtualDevice() {
        return this.virtualDevice;
    }

    public void setVirtualDevice(String virtualDevice) {
        this.virtualDevice = virtualDevice;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void setVrfInstance(String vrfInstance) {
        this.vrfInstance = vrfInstance;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLevel3(boolean level3) {
        this.level3 = level3;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        return this.id == other.id;
    }
}

