/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.attribute;

import java.io.File;
import java.nio.file.Paths;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.attribute.ConfigAttribute;

@Entity
@DiscriminatorValue(value="F")
public class ConfigBinaryFileAttribute
extends ConfigAttribute {
    private String uid;
    private String originalName;
    private long fileSize = 0L;

    protected ConfigBinaryFileAttribute() {
    }

    public ConfigBinaryFileAttribute(Config config, String name, String originalName) {
        super(config, name);
        this.uid = UUID.randomUUID().toString();
        this.originalName = originalName;
    }

    @Column(unique=true)
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    @Transient
    public File getFileName() {
        String path = Netshot.getConfig("netshot.snapshots.binary.path");
        if (path == null) {
            return null;
        }
        return Paths.get(path, String.format("%s.data", this.getUid())).normalize().toFile();
    }

    @Override
    @Transient
    public String getAsText() {
        return "";
    }

    @Override
    @Transient
    public Object getData() {
        return null;
    }

    @XmlElement
    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @XmlElement
    public long getFileSize() {
        return this.fileSize;
    }

    @XmlElement
    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
        result = 31 * result + (this.originalName == null ? 0 : this.originalName.hashCode());
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigBinaryFileAttribute other = (ConfigBinaryFileAttribute)obj;
        if (this.fileSize != other.fileSize) {
            return false;
        }
        if (this.originalName == null ? other.originalName != null : !this.originalName.equals(other.originalName)) {
            return false;
        }
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }
}

