/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ColumnValues {
    private String name = "";
    private boolean unique = false;
    private boolean nullable = true;
    private boolean insertable = true;
    private boolean updatable = true;
    private String columnDefinition = "";
    private String table = null;
    private int length = 255;
    private int precision = 0;
    private int scale = 0;

    ColumnValues() {
        this(null);
    }

    public ColumnValues(AnnotationInstance columnAnnotation) {
        if (columnAnnotation != null && !JPADotNames.COLUMN.equals(columnAnnotation.name())) {
            throw new AssertionFailure("A @Column annotation needs to be passed to the constructor");
        }
        this.applyColumnValues(columnAnnotation);
    }

    private void applyColumnValues(AnnotationInstance columnAnnotation) {
        AnnotationValue scaleValue;
        AnnotationValue precisionValue;
        AnnotationValue lengthValue;
        AnnotationValue tableValue;
        AnnotationValue columnDefinition;
        AnnotationValue updatableValue;
        AnnotationValue insertableValue;
        AnnotationValue nullableValue;
        AnnotationValue uniqueValue;
        if (columnAnnotation == null) {
            return;
        }
        AnnotationValue nameValue = columnAnnotation.value("name");
        if (nameValue != null) {
            this.name = nameValue.asString();
        }
        if ((uniqueValue = columnAnnotation.value("unique")) != null) {
            this.unique = nameValue.asBoolean();
        }
        if ((nullableValue = columnAnnotation.value("nullable")) != null) {
            this.nullable = nullableValue.asBoolean();
        }
        if ((insertableValue = columnAnnotation.value("insertable")) != null) {
            this.insertable = insertableValue.asBoolean();
        }
        if ((updatableValue = columnAnnotation.value("updatable")) != null) {
            this.updatable = updatableValue.asBoolean();
        }
        if ((columnDefinition = columnAnnotation.value("columnDefinition")) != null) {
            this.columnDefinition = columnDefinition.asString();
        }
        if ((tableValue = columnAnnotation.value("table")) != null) {
            this.table = tableValue.asString();
        }
        if ((lengthValue = columnAnnotation.value("length")) != null) {
            this.length = lengthValue.asInt();
        }
        if ((precisionValue = columnAnnotation.value("precision")) != null) {
            this.precision = precisionValue.asInt();
        }
        if ((scaleValue = columnAnnotation.value("scale")) != null) {
            this.scale = scaleValue.asInt();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public final boolean isNullable() {
        return this.nullable;
    }

    public final boolean isInsertable() {
        return this.insertable;
    }

    public final boolean isUpdatable() {
        return this.updatable;
    }

    public final String getColumnDefinition() {
        return this.columnDefinition;
    }

    public final String getTable() {
        return this.table;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ColumnValues");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", unique=").append(this.unique);
        sb.append(", nullable=").append(this.nullable);
        sb.append(", insertable=").append(this.insertable);
        sb.append(", updatable=").append(this.updatable);
        sb.append(", columnDefinition='").append(this.columnDefinition).append('\'');
        sb.append(", table='").append(this.table).append('\'');
        sb.append(", length=").append(this.length);
        sb.append(", precision=").append(this.precision);
        sb.append(", scale=").append(this.scale);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnValues that = (ColumnValues)o;
        if (this.insertable != that.insertable) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.nullable != that.nullable) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        if (this.scale != that.scale) {
            return false;
        }
        if (this.unique != that.unique) {
            return false;
        }
        if (this.updatable != that.updatable) {
            return false;
        }
        if (this.columnDefinition != null ? !this.columnDefinition.equals(that.columnDefinition) : that.columnDefinition != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.table != null ? !this.table.equals(that.table) : that.table != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.unique ? 1 : 0);
        result = 31 * result + (this.nullable ? 1 : 0);
        result = 31 * result + (this.insertable ? 1 : 0);
        result = 31 * result + (this.updatable ? 1 : 0);
        result = 31 * result + (this.columnDefinition != null ? this.columnDefinition.hashCode() : 0);
        result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
        result = 31 * result + this.length;
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }
}

