/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class CipherPool {
    private LinkedList<Cipher> availableCiphers;
    private int maxPoolSize;
    private int currentPoolSize = 0;

    public CipherPool() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public CipherPool(int maxPoolSize) {
        if (maxPoolSize < 0) {
            throw new IllegalArgumentException("Pool size must be >= 0");
        }
        this.maxPoolSize = maxPoolSize;
        this.availableCiphers = new LinkedList();
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized Cipher reuseCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = this.availableCiphers.poll();
        this.currentPoolSize = cipher == null ? 0 : --this.currentPoolSize;
        return cipher;
    }

    public synchronized void offerCipher(Cipher cipher) {
        if (this.currentPoolSize < this.maxPoolSize) {
            ++this.currentPoolSize;
            this.availableCiphers.offer(cipher);
        }
    }
}

