/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(36, 32, 88) % ivec3(36, 32, 88)) => ivec3(0, 0, 0)
 * (ivec3(36, 32, 88) % ivec3(59, 77, 68)) => ivec3(36, 32, 20)
 * (ivec3(59, 77, 68) % ivec3(36, 32, 88)) => ivec3(23, 13, 68)
 * (ivec3(59, 77, 68) % ivec3(59, 77, 68)) => ivec3(0, 0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec3(36, 32, 88) % ivec3(36, 32, 88)), ivec3(0, 0, 0))) ? 1 : -1] array0;
  float[all(equal((ivec3(36, 32, 88) % ivec3(59, 77, 68)), ivec3(36, 32, 20))) ? 1 : -1] array1;
  float[all(equal((ivec3(59, 77, 68) % ivec3(36, 32, 88)), ivec3(23, 13, 68))) ? 1 : -1] array2;
  float[all(equal((ivec3(59, 77, 68) % ivec3(59, 77, 68)), ivec3(0, 0, 0))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
