/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.hslf.exceptions.EncryptedPowerPointFileException;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.record.DocInfoListContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.VBAInfoAtom;
import org.apache.poi.hslf.record.VBAInfoContainer;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import org.apache.poi.hslf.usermodel.HSLFNotes;
import org.apache.poi.hslf.usermodel.HSLFObjectData;
import org.apache.poi.hslf.usermodel.HSLFObjectShape;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTable;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.sl.usermodel.Comment;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HSLFExtractor
extends AbstractPOIFSExtractor {
    public HSLFExtractor(ParseContext context, Metadata metadata) {
        super(context, metadata);
    }

    protected void parse(POIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        this.parse(filesystem.getRoot(), xhtml);
    }

    protected void parse(DirectoryNode root, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HSLFNotes notes;
        HSLFSlideShow ss;
        try {
            ss = new HSLFSlideShow(root);
        }
        catch (EncryptedPowerPointFileException e) {
            throw new EncryptedDocumentException((Throwable)e);
        }
        List _slides = ss.getSlides();
        xhtml.startElement("div", "class", "slideShow");
        for (HSLFSlide slide : _slides) {
            Object shape2;
            xhtml.startElement("div", "class", "slide");
            HeadersFooters hf = slide.getHeadersFooters();
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.extractMaster(xhtml, slide.getMasterSheet());
            xhtml.startElement("div", "class", "slide-content");
            this.textRunsToText(xhtml, slide.getTextParagraphs());
            xhtml.endElement("div");
            for (Object shape2 : slide.getShapes()) {
                if (!(shape2 instanceof HSLFTable)) continue;
                this.extractTableText(xhtml, (HSLFTable)shape2);
            }
            this.extractGroupText(xhtml, slide.getShapes(), 0);
            if (hf != null && hf.isFooterVisible() && hf.getFooterText() != null) {
                xhtml.startElement("p", "class", "slide-footer");
                xhtml.characters(hf.getFooterText());
                xhtml.endElement("p");
            }
            StringBuilder authorStringBuilder = new StringBuilder();
            shape2 = slide.getComments().iterator();
            while (shape2.hasNext()) {
                Comment comment = (Comment)shape2.next();
                authorStringBuilder.setLength(0);
                xhtml.startElement("p", "class", "slide-comment");
                if (comment.getAuthor() != null) {
                    authorStringBuilder.append(comment.getAuthor());
                }
                if (comment.getAuthorInitials() != null) {
                    if (authorStringBuilder.length() > 0) {
                        authorStringBuilder.append(" ");
                    }
                    authorStringBuilder.append("(" + comment.getAuthorInitials() + ")");
                }
                if (authorStringBuilder.length() > 0) {
                    if (comment.getText() != null) {
                        authorStringBuilder.append(" - ");
                    }
                    xhtml.startElement("b");
                    xhtml.characters(authorStringBuilder.toString());
                    xhtml.endElement("b");
                }
                if (comment.getText() != null) {
                    xhtml.characters(comment.getText());
                }
                xhtml.endElement("p");
            }
            this.handleSlideEmbeddedResources(slide, xhtml);
            notes = slide.getNotes();
            if (notes != null) {
                xhtml.startElement("div", "class", "slide-notes");
                this.textRunsToText(xhtml, notes.getTextParagraphs());
                xhtml.endElement("div");
            }
            xhtml.endElement("div");
        }
        xhtml.endElement("div");
        xhtml.startElement("div", "class", "slide-notes");
        HashSet<Integer> seenNotes = new HashSet<Integer>();
        HeadersFooters hf = ss.getNotesHeadersFooters();
        for (HSLFSlide slide : _slides) {
            Integer id;
            notes = slide.getNotes();
            if (notes == null || seenNotes.contains(id = Integer.valueOf(notes._getSheetNumber()))) continue;
            seenNotes.add(id);
            if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                xhtml.startElement("p", "class", "slide-note-header");
                xhtml.characters(hf.getHeaderText());
                xhtml.endElement("p");
            }
            this.textRunsToText(xhtml, notes.getTextParagraphs());
            if (hf == null || !hf.isFooterVisible() || hf.getFooterText() == null) continue;
            xhtml.startElement("p", "class", "slide-note-footer");
            xhtml.characters(hf.getFooterText());
            xhtml.endElement("p");
        }
        this.handleSlideEmbeddedPictures(ss, xhtml);
        if (this.officeParserConfig.getExtractMacros()) {
            this.extractMacros(ss, xhtml);
        }
        xhtml.endElement("div");
    }

    private void extractGroupText(XHTMLContentHandler xhtml, List<HSLFShape> shapes, int depth) throws SAXException {
        if (shapes == null) {
            return;
        }
        ArrayList<List<HSLFTextParagraph>> paragraphList = new ArrayList<List<HSLFTextParagraph>>();
        for (HSLFShape shape : shapes) {
            if (shape instanceof HSLFGroupShape) {
                this.extractGroupText(xhtml, ((HSLFGroupShape)shape).getShapes(), depth + 1);
                continue;
            }
            if (!(shape instanceof HSLFTextShape) || shape instanceof HSLFTableCell || depth <= 0) continue;
            paragraphList.add(((HSLFTextShape)shape).getTextParagraphs());
        }
        this.textRunsToText(xhtml, paragraphList);
    }

    private void extractMacros(HSLFSlideShow ppt, XHTMLContentHandler xhtml) {
        DocInfoListContainer list = (DocInfoListContainer)ppt.getDocumentRecord().findFirstOfType((long)RecordTypes.List.typeID);
        if (list == null) {
            return;
        }
        VBAInfoContainer vbaInfo = (VBAInfoContainer)list.findFirstOfType((long)RecordTypes.VBAInfo.typeID);
        if (vbaInfo == null) {
            return;
        }
        VBAInfoAtom vbaAtom = (VBAInfoAtom)vbaInfo.findFirstOfType((long)RecordTypes.VBAInfoAtom.typeID);
        if (vbaAtom == null) {
            return;
        }
        long persistId = vbaAtom.getPersistIdRef();
        for (HSLFObjectData objData : ppt.getEmbeddedObjects()) {
            if ((long)objData.getExOleObjStg().getPersistId() != persistId) continue;
            try (POIFSFileSystem poifsFileSystem = new POIFSFileSystem(objData.getInputStream());){
                try {
                    OfficeParser.extractMacros(poifsFileSystem, (ContentHandler)xhtml, EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)this.context));
                }
                catch (IOException | SAXException inner) {
                    EmbeddedDocumentUtil.recordException((Throwable)inner, (Metadata)this.parentMetadata);
                }
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
            }
        }
    }

    private void extractMaster(XHTMLContentHandler xhtml, HSLFMasterSheet master) throws SAXException {
        if (master == null) {
            return;
        }
        List shapes = master.getShapes();
        if (shapes == null || shapes.isEmpty()) {
            return;
        }
        xhtml.startElement("div", "class", "slide-master-content");
        for (HSLFShape shape : shapes) {
            HSLFTextShape tsh;
            String text;
            if (shape == null || this.isPlaceholder(shape) || !(shape instanceof HSLFTextShape) || (text = (tsh = (HSLFTextShape)shape).getText()) == null) continue;
            xhtml.element("p", text);
        }
        xhtml.endElement("div");
    }

    private boolean isPlaceholder(HSLFShape shape) {
        return shape instanceof SimpleShape && ((SimpleShape)shape).isPlaceholder();
    }

    private void extractTableText(XHTMLContentHandler xhtml, HSLFTable shape) throws SAXException {
        xhtml.startElement("table");
        for (int row = 0; row < shape.getNumberOfRows(); ++row) {
            xhtml.startElement("tr");
            for (int col = 0; col < shape.getNumberOfColumns(); ++col) {
                HSLFTableCell cell = shape.getCell(row, col);
                String txt = "";
                if (cell != null) {
                    txt = cell.getText();
                }
                xhtml.element("td", txt);
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("table");
    }

    private void textRunsToText(XHTMLContentHandler xhtml, List<List<HSLFTextParagraph>> paragraphsList) throws SAXException {
        if (paragraphsList == null) {
            return;
        }
        for (List<HSLFTextParagraph> run : paragraphsList) {
            boolean isBullet = false;
            for (HSLFTextParagraph htp : run) {
                boolean nextBullet = htp.isBullet();
                if (isBullet != nextBullet) {
                    isBullet = nextBullet;
                    if (isBullet) {
                        xhtml.startElement("ul");
                    } else {
                        xhtml.endElement("ul");
                    }
                }
                List textRuns = htp.getTextRuns();
                String firstLine = HSLFExtractor.removePBreak(((HSLFTextRun)textRuns.get(0)).getRawText());
                boolean showBullet = isBullet && (textRuns.size() > 1 || !"".equals(firstLine));
                String paraTag = showBullet ? "li" : "p";
                xhtml.startElement(paraTag);
                boolean runIsHyperLink = false;
                for (HSLFTextRun htr : textRuns) {
                    String line;
                    String address;
                    HSLFHyperlink link = htr.getHyperlink();
                    if (link != null && (address = link.getAddress()) != null && !address.startsWith("_ftn")) {
                        xhtml.startElement("a", "href", link.getAddress());
                        runIsHyperLink = true;
                    }
                    if ((line = htr.getRawText()) != null) {
                        boolean isfirst = true;
                        for (String fragment : line.split("\\u000b")) {
                            if (!isfirst) {
                                xhtml.startElement("br");
                                xhtml.endElement("br");
                            }
                            isfirst = false;
                            xhtml.characters(HSLFExtractor.removePBreak(fragment));
                        }
                        if (line.endsWith("\u000b")) {
                            xhtml.startElement("br");
                            xhtml.endElement("br");
                        }
                    }
                    if (runIsHyperLink) {
                        xhtml.endElement("a");
                    }
                    runIsHyperLink = false;
                }
                xhtml.endElement(paraTag);
            }
            if (!isBullet) continue;
            xhtml.endElement("ul");
        }
    }

    private static String removePBreak(String fragment) {
        return fragment.replaceFirst("\\r$", "");
    }

    private void handleSlideEmbeddedPictures(HSLFSlideShow slideshow, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        for (HSLFPictureData pic : slideshow.getPictureData()) {
            String mediaType;
            switch (pic.getType()) {
                case EMF: {
                    mediaType = "image/emf";
                    break;
                }
                case WMF: {
                    mediaType = "image/wmf";
                    break;
                }
                case DIB: {
                    mediaType = "image/bmp";
                    break;
                }
                default: {
                    mediaType = pic.getContentType();
                }
            }
            byte[] data = null;
            try {
                data = pic.getData();
            }
            catch (Exception e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
                continue;
            }
            TikaInputStream picIs = TikaInputStream.get((byte[])data);
            Throwable throwable = null;
            try {
                this.handleEmbeddedResource(picIs, null, null, mediaType, xhtml, false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (picIs == null) continue;
                if (throwable != null) {
                    try {
                        picIs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                picIs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSlideEmbeddedResources(HSLFSlide slide, XHTMLContentHandler xhtml) throws TikaException, SAXException, IOException {
        List shapes;
        try {
            shapes = slide.getShapes();
        }
        catch (NullPointerException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
            return;
        }
        for (HSLFShape shape : shapes) {
            if (!(shape instanceof HSLFObjectShape)) continue;
            HSLFObjectShape oleShape = (HSLFObjectShape)shape;
            HSLFObjectData data = null;
            try {
                data = oleShape.getObjectData();
            }
            catch (NullPointerException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
                continue;
            }
            if (data == null) continue;
            String objID = Integer.toString(oleShape.getObjectID());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            attributes.addAttribute("", "id", "id", "CDATA", objID);
            xhtml.startElement("div", attributes);
            xhtml.endElement("div");
            InputStream dataStream = null;
            try {
                dataStream = data.getInputStream();
            }
            catch (Exception e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
                continue;
            }
            try {
                TikaInputStream stream = TikaInputStream.get((InputStream)dataStream);
                Throwable throwable = null;
                try {
                    String mediaType = null;
                    if ("Excel.Chart.8".equals(oleShape.getProgId())) {
                        mediaType = "application/vnd.ms-excel";
                    } else {
                        MediaType mt = this.getTikaConfig().getDetector().detect((InputStream)stream, new Metadata());
                        mediaType = mt.toString();
                    }
                    if (mediaType.equals("application/x-tika-msoffice-embedded; format=comp_obj") || mediaType.equals("application/x-tika-msoffice")) {
                        POIFSFileSystem poifs = null;
                        try {
                            poifs = new POIFSFileSystem((InputStream)new CloseShieldInputStream((InputStream)stream));
                        }
                        catch (RuntimeException e) {
                            throw new IOExceptionWithCause((Throwable)e);
                        }
                        try {
                            this.handleEmbeddedOfficeDoc((DirectoryEntry)poifs.getRoot(), objID, xhtml);
                            continue;
                        }
                        finally {
                            if (poifs == null) continue;
                            poifs.close();
                            continue;
                        }
                    }
                    this.handleEmbeddedResource(stream, objID, objID, mediaType, xhtml, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
            }
        }
    }
}

