/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools;

import java.util.Map;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.Toolbox;
import org.apache.velocity.tools.ToolboxFactory;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolManager {
    protected VelocityEngine velocity;
    protected ToolboxFactory factory = new ToolboxFactory();
    protected Logger log = null;
    private Toolbox application;
    private boolean userOverwrite = true;

    public ToolManager() {
        this(true, true);
    }

    public ToolManager(boolean includeDefaults) {
        this(true, includeDefaults);
    }

    public ToolManager(boolean autoConfig, boolean includeDefaults) {
        if (autoConfig) {
            this.autoConfigure(includeDefaults);
        }
    }

    public void autoConfigure(boolean includeDefaults) {
        FactoryConfiguration sys = ConfigurationUtils.findFromSystemProperty();
        if (sys != null) {
            this.configure(sys);
        }
    }

    public void configure(FactoryConfiguration config) {
        this.application = null;
        this.factory.configure(config);
    }

    public void configure(String path) {
        FactoryConfiguration config = this.findConfig(path);
        if (config == null) {
            throw new RuntimeException("Could not find any configuration at " + path);
        }
        this.configure(config);
    }

    protected FactoryConfiguration findConfig(String path) {
        return ConfigurationUtils.find(path);
    }

    public ToolboxFactory getToolboxFactory() {
        return this.factory;
    }

    public void setToolboxFactory(ToolboxFactory factory) {
        if (this.factory != factory) {
            if (factory == null) {
                throw new NullPointerException("ToolboxFactory cannot be null");
            }
            this.getLog().debug("ToolboxFactory instance was changed to {}", (Object)factory);
            this.factory = factory;
        }
    }

    public void setVelocityEngine(VelocityEngine engine) {
        if (this.velocity != engine) {
            this.getLog().debug("VelocityEngine instance was changed to {}", (Object)engine);
            this.velocity = engine;
        }
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocity;
    }

    public void setUserCanOverwriteTools(boolean overwrite) {
        this.userOverwrite = overwrite;
    }

    public boolean getUserCanOverwriteTools() {
        return this.userOverwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLog() {
        if (this.log == null) {
            ToolManager toolManager = this;
            synchronized (toolManager) {
                if (this.log == null) {
                    this.initLog();
                }
            }
        }
        return this.log;
    }

    protected void initLog() {
        this.log = this.velocity == null ? LoggerFactory.getLogger(ToolManager.class) : ConfigurationUtils.getLog(this.velocity, "tools");
    }

    public ToolContext createContext() {
        return this.createContext(null);
    }

    public ToolContext createContext(Map<String, Object> toolProps) {
        ToolContext context = new ToolContext(toolProps);
        this.prepareContext(context);
        return context;
    }

    protected void prepareContext(ToolContext context) {
        context.setUserCanOverwriteTools(this.userOverwrite);
        if (this.velocity != null) {
            context.putVelocityEngine(this.velocity);
        }
        this.addToolboxes(context);
    }

    protected void addToolboxes(ToolContext context) {
        if (this.hasApplicationTools()) {
            context.addToolbox(this.getApplicationToolbox());
        }
        if (this.hasRequestTools()) {
            context.addToolbox(this.getRequestToolbox());
        }
    }

    protected boolean hasTools(String scope) {
        return this.factory.hasTools(scope);
    }

    protected Toolbox createToolbox(String scope) {
        return this.factory.createToolbox(scope);
    }

    protected boolean hasRequestTools() {
        return this.hasTools("request");
    }

    protected Toolbox getRequestToolbox() {
        return this.createToolbox("request");
    }

    protected boolean hasApplicationTools() {
        return this.hasTools("application");
    }

    protected Toolbox getApplicationToolbox() {
        if (this.application == null && this.hasApplicationTools()) {
            this.application = this.createToolbox("application");
        }
        return this.application;
    }
}

