/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.pdmodel.PDDocument;

public final class OverlayPDF {
    private static final Log LOG = LogFactory.getLog(OverlayPDF.class);
    private static final String POSITION = "-position";
    private static final String ODD = "-odd";
    private static final String EVEN = "-even";
    private static final String FIRST = "-first";
    private static final String LAST = "-last";
    private static final String PAGE = "-page";
    private static final String USEALLPAGES = "-useAllPages";

    private OverlayPDF() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        String outputFilename = null;
        Overlay overlayer = new Overlay();
        HashMap<Integer, String> specificPageOverlayFile = new HashMap<Integer, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (i == 0) {
                overlayer.setInputFile(arg);
                continue;
            }
            if (i == args.length - 1) {
                outputFilename = arg;
                continue;
            }
            if (arg.equals(POSITION) && i + 1 < args.length) {
                if (Overlay.Position.FOREGROUND.toString().equalsIgnoreCase(args[i + 1].trim())) {
                    overlayer.setOverlayPosition(Overlay.Position.FOREGROUND);
                } else if (Overlay.Position.BACKGROUND.toString().equalsIgnoreCase(args[i + 1].trim())) {
                    overlayer.setOverlayPosition(Overlay.Position.BACKGROUND);
                } else {
                    OverlayPDF.usage();
                }
                ++i;
                continue;
            }
            if (arg.equals(ODD) && i + 1 < args.length) {
                overlayer.setOddPageOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(EVEN) && i + 1 < args.length) {
                overlayer.setEvenPageOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(FIRST) && i + 1 < args.length) {
                overlayer.setFirstPageOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(LAST) && i + 1 < args.length) {
                overlayer.setLastPageOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(USEALLPAGES) && i + 1 < args.length) {
                overlayer.setAllPagesOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(PAGE) && i + 2 < args.length && OverlayPDF.isInteger(args[i + 1].trim())) {
                specificPageOverlayFile.put(Integer.parseInt(args[i + 1].trim()), args[i + 2].trim());
                i += 2;
                continue;
            }
            if (overlayer.getDefaultOverlayFile() == null) {
                overlayer.setDefaultOverlayFile(arg);
                continue;
            }
            OverlayPDF.usage();
        }
        if (overlayer.getInputFile() == null || outputFilename == null) {
            OverlayPDF.usage();
        }
        try {
            PDDocument result = overlayer.overlay(specificPageOverlayFile);
            result.save(outputFilename);
            result.close();
            overlayer.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Overlay failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar OverlayPDF <inputfile> [options] <outputfile>\n\nOptions:\n  <inputfile>                                  : input file\n  <defaultOverlay.pdf>                         : default overlay file\n  -odd <oddPageOverlay.pdf>                    : overlay file used for odd pages\n  -even <evenPageOverlay.pdf>                  : overlay file used for even pages\n  -first <firstPageOverlay.pdf>                : overlay file used for the first page\n  -last <lastPageOverlay.pdf>                  : overlay file used for the last page\n  -useAllPages <allPagesOverlay.pdf>           : overlay file used for overlay, all pages are used by simply repeating them\n  -page <pageNumber> <specificPageOverlay.pdf> : overlay file used for the given page number, may occur more than once\n  -position foreground|background              : where to put the overlay file: foreground or background\n  <outputfile>                                 : output file";
        System.err.println(message);
        System.exit(1);
    }

    private static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

