/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.CategoryRoutedAlias;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.update.AddUpdateCommand;

public interface RoutedAlias {
    public static final String ROUTER_TYPE_NAME = "router.name";
    public static final String ROUTER_FIELD = "router.field";
    public static final String CREATE_COLLECTION_PREFIX = "create-collection.";
    public static final Set<String> MINIMAL_REQUIRED_PARAMS = Sets.newHashSet((Object[])new String[]{"router.name", "router.field"});
    public static final String ROUTED_ALIAS_NAME_CORE_PROP = "routedAliasName";

    public static SolrException newAliasMustExistException(String aliasName) {
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Routed alias " + aliasName + " appears to have been removed during request processing.");
    }

    public static RoutedAlias fromProps(String aliasName, Map<String, String> props) throws SolrException {
        SupportedRouterTypes routerType;
        String typeStr = props.get(ROUTER_TYPE_NAME);
        if (typeStr == null) {
            return null;
        }
        try {
            routerType = SupportedRouterTypes.valueOf(typeStr.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Router name: " + typeStr + " is not in supported types, " + Arrays.asList(SupportedRouterTypes.values()));
        }
        switch (routerType) {
            case TIME: {
                return new TimeRoutedAlias(aliasName, props);
            }
            case CATEGORY: {
                return new CategoryRoutedAlias(aliasName, props);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Router " + (Object)((Object)routerType) + " is not fully implemented. If you see thiserror in an official release please file a bug report. Available types were:" + Arrays.asList(SupportedRouterTypes.values()));
    }

    public boolean updateParsedCollectionAliases(ZkController var1);

    public String computeInitialCollectionName();

    public String getAliasName();

    public String getRouteField();

    public void validateRouteValue(AddUpdateCommand var1) throws SolrException;

    public String createCollectionsIfRequired(AddUpdateCommand var1);

    public Map<String, String> getAliasMetadata();

    public Set<String> getRequiredParams();

    public Set<String> getOptionalParams();

    public static enum SupportedRouterTypes {
        TIME{

            @Override
            public String getSeparatorPrefix() {
                return "__TRA__";
            }
        }
        ,
        CATEGORY{

            @Override
            public String getSeparatorPrefix() {
                return "__CRA__";
            }
        };


        public abstract String getSeparatorPrefix();
    }
}

