/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;

public class LineFileDocs
implements Closeable {
    private BufferedReader reader;
    private static final int BUFFER_SIZE = 65536;
    private final AtomicInteger id = new AtomicInteger();
    private final String path;
    private final Random random;
    private static final char SEP = '\t';
    private final CloseableThreadLocal<DocState> threadDocs = new CloseableThreadLocal();

    public LineFileDocs(Random random, String path) throws IOException {
        this.path = path;
        this.random = new Random(random.nextLong());
        this.open(random);
    }

    public LineFileDocs(Random random) throws IOException {
        this(random, LuceneTestCase.TEST_LINE_DOCS_FILE);
    }

    @Override
    public synchronized void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.reader, this.threadDocs});
        this.reader = null;
    }

    private long randomSeekPos(Random random, long size) {
        if (random == null || size <= 3L) {
            return 0L;
        }
        return (random.nextLong() & Long.MAX_VALUE) % (size / 3L);
    }

    private synchronized void open(Random random) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(this.path);
        boolean needSkip = true;
        long size = 0L;
        long seekTo = 0L;
        if (is == null) {
            Path file = Paths.get(this.path, new String[0]);
            size = Files.size(file);
            if (this.path.endsWith(".gz")) {
                is = Files.newInputStream(file, new OpenOption[0]);
            } else {
                seekTo = this.randomSeekPos(random, size);
                SeekableByteChannel channel = Files.newByteChannel(file, new OpenOption[0]);
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: LineFileDocs: file seek to fp=" + seekTo + " on open");
                }
                channel.position(seekTo);
                is = Channels.newInputStream(channel);
                needSkip = false;
            }
        } else {
            size = is.available();
        }
        if (this.path.endsWith(".gz")) {
            is = new GZIPInputStream(is);
            size = (long)((double)size * 2.8);
        }
        if (needSkip) {
            seekTo = this.randomSeekPos(random, size);
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: LineFileDocs: stream skip to fp=" + seekTo + " on open");
            }
            is.skip(seekTo);
        }
        if (seekTo > 0L) {
            int b;
            while ((b = is.read()) >= 0 && b != 13 && b != 10) {
            }
        }
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.reader = new BufferedReader(new InputStreamReader(is, decoder), 65536);
        if (seekTo > 0L) {
            this.reader.readLine();
        }
    }

    public synchronized void reset(Random random) throws IOException {
        this.reader.close();
        this.reader = null;
        this.open(random);
        this.id.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document nextDoc() throws IOException {
        int spot;
        String line;
        LineFileDocs lineFileDocs = this;
        synchronized (lineFileDocs) {
            line = this.reader.readLine();
            if (line == null) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: LineFileDocs: now rewind file...");
                }
                this.reader.close();
                this.reader = null;
                this.open(null);
                line = this.reader.readLine();
            }
        }
        DocState docState = (DocState)this.threadDocs.get();
        if (docState == null) {
            docState = new DocState();
            this.threadDocs.set((Object)docState);
        }
        if ((spot = line.indexOf(9)) == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        int spot2 = line.indexOf(9, 1 + spot);
        if (spot2 == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        docState.body.setStringValue(line.substring(1 + spot2, line.length()));
        String title = line.substring(0, spot);
        docState.title.setStringValue(title);
        if (docState.titleDV != null) {
            docState.titleDV.setBytesValue(new BytesRef((CharSequence)title));
        }
        docState.titleTokenized.setStringValue(title);
        docState.date.setStringValue(line.substring(1 + spot, spot2));
        int i = this.id.getAndIncrement();
        docState.id.setStringValue(Integer.toString(i));
        docState.idNum.setIntValue(i);
        if (docState.idNumDV != null) {
            docState.idNumDV.setLongValue((long)i);
        }
        if (this.random.nextInt(5) == 4) {
            Document doc = new Document();
            for (IndexableField field : docState.doc) {
                doc.add(field);
            }
            if (this.random.nextInt(3) == 1) {
                int x = this.random.nextInt(4);
                doc.add((IndexableField)new IntPoint("docLength" + x, new int[]{line.length()}));
            }
            if (this.random.nextInt(3) == 1) {
                int x = this.random.nextInt(4);
                doc.add((IndexableField)new IntPoint("docTitleLength" + x, new int[]{title.length()}));
            }
            if (this.random.nextInt(3) == 1) {
                int x = this.random.nextInt(4);
                doc.add((IndexableField)new NumericDocValuesField("docLength" + x, (long)line.length()));
            }
        }
        return docState.doc;
    }

    private static final class DocState {
        final Document doc = new Document();
        final Field titleTokenized;
        final Field title = new StringField("title", "", Field.Store.NO);
        final Field titleDV;
        final Field body;
        final Field id;
        final Field idNum;
        final Field idNumDV;
        final Field date;

        public DocState() {
            this.doc.add((IndexableField)this.title);
            FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
            ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            ft.setStoreTermVectors(true);
            ft.setStoreTermVectorOffsets(true);
            ft.setStoreTermVectorPositions(true);
            this.titleTokenized = new Field("titleTokenized", (CharSequence)"", (IndexableFieldType)ft);
            this.doc.add((IndexableField)this.titleTokenized);
            this.body = new Field("body", (CharSequence)"", (IndexableFieldType)ft);
            this.doc.add((IndexableField)this.body);
            this.id = new StringField("docid", "", Field.Store.YES);
            this.doc.add((IndexableField)this.id);
            this.idNum = new IntPoint("docid_int", new int[]{0});
            this.doc.add((IndexableField)this.idNum);
            this.date = new StringField("date", "", Field.Store.YES);
            this.doc.add((IndexableField)this.date);
            this.titleDV = new SortedDocValuesField("titleDV", new BytesRef());
            this.idNumDV = new NumericDocValuesField("docid_intDV", 0L);
            this.doc.add((IndexableField)this.titleDV);
            this.doc.add((IndexableField)this.idNumDV);
        }
    }
}

