/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;

public class DocCollection
extends ZkNodeProps
implements Iterable<Slice> {
    public static final String DOC_ROUTER = "router";
    public static final String SHARDS = "shards";
    public static final String STATE_FORMAT = "stateFormat";
    public static final String RULE = "rule";
    public static final String SNITCH = "snitch";
    private final int znodeVersion;
    private final String name;
    private final Map<String, Slice> slices;
    private final Map<String, Slice> activeSlices;
    private final Slice[] activeSlicesArr;
    private final Map<String, List<Replica>> nodeNameReplicas;
    private final Map<String, List<Replica>> nodeNameLeaderReplicas;
    private final DocRouter router;
    private final String znode;
    private final Integer replicationFactor;
    private final Integer numNrtReplicas;
    private final Integer numTlogReplicas;
    private final Integer numPullReplicas;
    private final Integer maxShardsPerNode;
    private final Boolean autoAddReplicas;
    private final String policy;
    private final Boolean readOnly;

    public DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router) {
        this(name, slices, props, router, Integer.MAX_VALUE, "/clusterstate.json");
    }

    public DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router, int zkVersion, String znode) {
        super(props == null ? (props = new HashMap<String, Object>()) : props);
        this.znodeVersion = zkVersion == -1 ? Integer.MAX_VALUE : zkVersion;
        this.name = name;
        this.slices = slices;
        this.activeSlices = new HashMap<String, Slice>();
        this.nodeNameLeaderReplicas = new HashMap<String, List<Replica>>();
        this.nodeNameReplicas = new HashMap<String, List<Replica>>();
        this.replicationFactor = (Integer)DocCollection.verifyProp(props, "replicationFactor");
        this.numNrtReplicas = (Integer)DocCollection.verifyProp(props, "nrtReplicas", 0);
        this.numTlogReplicas = (Integer)DocCollection.verifyProp(props, "tlogReplicas", 0);
        this.numPullReplicas = (Integer)DocCollection.verifyProp(props, "pullReplicas", 0);
        this.maxShardsPerNode = (Integer)DocCollection.verifyProp(props, "maxShardsPerNode");
        Boolean autoAddReplicas = (Boolean)DocCollection.verifyProp(props, "autoAddReplicas");
        this.policy = (String)props.get("policy");
        this.autoAddReplicas = autoAddReplicas == null ? Boolean.FALSE : autoAddReplicas;
        Boolean readOnly = (Boolean)DocCollection.verifyProp(props, "readOnly");
        this.readOnly = readOnly == null ? Boolean.FALSE : readOnly;
        DocCollection.verifyProp(props, RULE);
        DocCollection.verifyProp(props, SNITCH);
        for (Map.Entry<String, Slice> slice : slices.entrySet()) {
            if (slice.getValue().getState() == Slice.State.ACTIVE) {
                this.activeSlices.put(slice.getKey(), slice.getValue());
            }
            for (Replica replica : slice.getValue()) {
                this.addNodeNameReplica(replica);
            }
        }
        this.activeSlicesArr = this.activeSlices.values().toArray(new Slice[this.activeSlices.size()]);
        this.router = router;
        String string = this.znode = znode == null ? "/clusterstate.json" : znode;
        assert (name != null && slices != null);
    }

    private void addNodeNameReplica(Replica replica) {
        List<Replica> replicas = this.nodeNameReplicas.get(replica.getNodeName());
        if (replicas == null) {
            replicas = new ArrayList<Replica>();
            this.nodeNameReplicas.put(replica.getNodeName(), replicas);
        }
        replicas.add(replica);
        if (replica.getStr("leader") != null) {
            List<Replica> leaderReplicas = this.nodeNameLeaderReplicas.get(replica.getNodeName());
            if (leaderReplicas == null) {
                leaderReplicas = new ArrayList<Replica>();
                this.nodeNameLeaderReplicas.put(replica.getNodeName(), leaderReplicas);
            }
            leaderReplicas.add(replica);
        }
    }

    public static Object verifyProp(Map<String, Object> props, String propName) {
        return DocCollection.verifyProp(props, propName, null);
    }

    public static Object verifyProp(Map<String, Object> props, String propName, Object def) {
        Object o = props.get(propName);
        if (o == null) {
            return def;
        }
        switch (propName) {
            case "maxShardsPerNode": 
            case "replicationFactor": 
            case "nrtReplicas": 
            case "pullReplicas": 
            case "tlogReplicas": {
                return Integer.parseInt(o.toString());
            }
            case "autoAddReplicas": 
            case "readOnly": {
                return Boolean.parseBoolean(o.toString());
            }
            case "snitch": 
            case "rule": {
                return (List)o;
            }
        }
        return o;
    }

    public DocCollection copyWithSlices(Map<String, Slice> slices) {
        return new DocCollection(this.getName(), slices, this.propMap, this.router, this.znodeVersion, this.znode);
    }

    public String getName() {
        return this.name;
    }

    public Slice getSlice(String sliceName) {
        return this.slices.get(sliceName);
    }

    public void forEachReplica(BiConsumer<String, Replica> consumer) {
        this.slices.forEach((? super K shard, ? super V slice) -> slice.getReplicasMap().forEach((? super K s, ? super V replica) -> consumer.accept((String)shard, (Replica)replica)));
    }

    public Collection<Slice> getSlices() {
        return this.slices.values();
    }

    public Collection<Slice> getActiveSlices() {
        return this.activeSlices.values();
    }

    public Slice[] getActiveSlicesArr() {
        return this.activeSlicesArr;
    }

    public Map<String, Slice> getSlicesMap() {
        return this.slices;
    }

    public Map<String, Slice> getActiveSlicesMap() {
        return this.activeSlices;
    }

    public List<Replica> getReplicas(String nodeName) {
        return this.nodeNameReplicas.get(nodeName);
    }

    public List<Replica> getLeaderReplicas(String nodeName) {
        return this.nodeNameLeaderReplicas.get(nodeName);
    }

    public int getZNodeVersion() {
        return this.znodeVersion;
    }

    public int getStateFormat() {
        return "/clusterstate.json".equals(this.znode) ? 1 : 2;
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public boolean getAutoAddReplicas() {
        return this.autoAddReplicas;
    }

    public int getMaxShardsPerNode() {
        if (this.maxShardsPerNode == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "maxShardsPerNode is not in the cluster state.");
        }
        return this.maxShardsPerNode == 0 ? Integer.MAX_VALUE : this.maxShardsPerNode;
    }

    public String getZNode() {
        return this.znode;
    }

    public DocRouter getRouter() {
        return this.router;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String toString() {
        return "DocCollection(" + this.name + "/" + this.znode + "/" + this.znodeVersion + ")=" + Utils.toJSONString(this);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        LinkedHashMap<String, Map<String, Slice>> all = new LinkedHashMap<String, Map<String, Slice>>(this.slices.size() + 1);
        all.putAll(this.propMap);
        all.put(SHARDS, this.slices);
        jsonWriter.write(all);
    }

    public Replica getReplica(String coreNodeName) {
        for (Slice slice : this.slices.values()) {
            Replica replica = slice.getReplica(coreNodeName);
            if (replica == null) continue;
            return replica;
        }
        return null;
    }

    public Replica getLeader(String sliceName) {
        Slice slice = this.getSlice(sliceName);
        if (slice == null) {
            return null;
        }
        return slice.getLeader();
    }

    public static boolean isFullyActive(Set<String> liveNodes, DocCollection collectionState, int expectedShards, int expectedReplicas) {
        Objects.requireNonNull(liveNodes);
        if (collectionState == null) {
            return false;
        }
        int activeShards = 0;
        for (Slice slice : collectionState) {
            int activeReplicas = 0;
            for (Replica replica : slice) {
                if (!replica.isActive(liveNodes)) {
                    return false;
                }
                ++activeReplicas;
            }
            if (activeReplicas != expectedReplicas) {
                return false;
            }
            ++activeShards;
        }
        return activeShards == expectedShards;
    }

    @Override
    public Iterator<Slice> iterator() {
        return this.slices.values().iterator();
    }

    public List<Replica> getReplicas() {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Slice slice : this) {
            replicas.addAll(slice.getReplicas());
        }
        return replicas;
    }

    public Replica getReplica(BiPredicate<String, Replica> predicate) {
        Replica[] result = new Replica[1];
        this.forEachReplica((s, replica) -> {
            if (result[0] != null) {
                return;
            }
            if (predicate.test((String)s, (Replica)replica)) {
                result[0] = replica;
            }
        });
        return result[0];
    }

    public List<Replica> getReplicas(EnumSet<Replica.Type> s) {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Slice slice : this) {
            replicas.addAll(slice.getReplicas(s));
        }
        return replicas;
    }

    public String getShardId(String nodeName, String coreName) {
        for (Slice slice : this) {
            for (Replica replica : slice) {
                if (!Objects.equals(replica.getNodeName(), nodeName) || !Objects.equals(replica.getCoreName(), coreName)) continue;
                return slice.getName();
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof DocCollection)) {
            return false;
        }
        DocCollection other = (DocCollection)that;
        return super.equals(that) && Objects.equals(this.znode, other.znode) && this.znodeVersion == other.znodeVersion;
    }

    public Integer getNumNrtReplicas() {
        return this.numNrtReplicas;
    }

    public Integer getNumTlogReplicas() {
        return this.numTlogReplicas;
    }

    public Integer getNumPullReplicas() {
        return this.numPullReplicas;
    }

    public String getPolicyName() {
        return this.policy;
    }

    public int getExpectedReplicaCount(Replica.Type type, int def) {
        Integer result = null;
        if (type == Replica.Type.NRT) {
            result = this.numNrtReplicas;
        }
        if (type == Replica.Type.PULL) {
            result = this.numPullReplicas;
        }
        if (type == Replica.Type.TLOG) {
            result = this.numTlogReplicas;
        }
        return result == null ? def : result;
    }
}

