/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class CharSequenceAccessor {
    private static final Constructor<String> stringConstructor;
    private static final Field stringValueField;
    private static final Field stringOffsetField;
    private static final Field stringCountField;
    private static final boolean hasStringFields;
    private static final Field stringBuilderValueField;
    private static final Field stringBuilderCountField;
    private static final boolean hasStringBuilderFields;

    public static CharArrayWrapper access(CharSequence str) {
        if (str == null) {
            return null;
        }
        try {
            if (str instanceof String) {
                if (hasStringFields) {
                    CharArrayWrapper w = new CharArrayWrapper();
                    w.value = (char[])stringValueField.get(str);
                    w.offset = stringOffsetField.getInt(str);
                    w.length = stringCountField.getInt(str);
                    return w;
                }
            } else if (str instanceof StringBuilder && hasStringBuilderFields) {
                CharArrayWrapper w = new CharArrayWrapper();
                w.value = (char[])stringBuilderValueField.get(str);
                w.length = stringBuilderCountField.getInt(str);
                return w;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String createOptimizedString(char[] buffer, int offset, int length) {
        try {
            if (hasStringFields) {
                String s = new String();
                stringValueField.set(s, buffer);
                if (offset != 0) {
                    stringOffsetField.setInt(s, offset);
                }
                stringCountField.setInt(s, length);
                return s;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new String(buffer, offset, length);
    }

    public static void updateStringBuilder(StringBuilder sb, int newLength) {
        try {
            if (hasStringBuilderFields) {
                stringBuilderCountField.setInt(sb, newLength);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to update count field for StringBuilder");
        }
    }

    static {
        Constructor stringConstructorTemp = null;
        Field stringValueFieldTemp = null;
        Field stringOffsetFieldTemp = null;
        Field stringCountFieldTemp = null;
        Field stringBuilderValueFieldTemp = null;
        Field stringBuilderCountFieldTemp = null;
        boolean hasStringFieldsTemp = false;
        boolean hasStringBuilderFieldsTemp = false;
        try {
            stringValueFieldTemp = String.class.getDeclaredField("value");
            stringValueFieldTemp.setAccessible(true);
            stringOffsetFieldTemp = String.class.getDeclaredField("offset");
            stringOffsetFieldTemp.setAccessible(true);
            stringCountFieldTemp = String.class.getDeclaredField("count");
            stringCountFieldTemp.setAccessible(true);
            hasStringFieldsTemp = true;
            stringConstructorTemp = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            stringBuilderValueFieldTemp = StringBuilder.class.getSuperclass().getDeclaredField("value");
            stringBuilderValueFieldTemp.setAccessible(true);
            stringBuilderCountFieldTemp = StringBuilder.class.getSuperclass().getDeclaredField("count");
            stringBuilderCountFieldTemp.setAccessible(true);
            hasStringBuilderFieldsTemp = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        stringValueField = stringValueFieldTemp;
        stringOffsetField = stringOffsetFieldTemp;
        stringCountField = stringCountFieldTemp;
        hasStringFields = hasStringFieldsTemp;
        stringConstructor = stringConstructorTemp;
        stringBuilderValueField = stringBuilderValueFieldTemp;
        stringBuilderCountField = stringBuilderCountFieldTemp;
        hasStringBuilderFields = hasStringBuilderFieldsTemp;
    }

    public static class CharArrayWrapper {
        public char[] value;
        public int offset;
        public int length;
    }
}

