/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import java.io.IOException;
import java.io.Writer;
import net.arnx.jsonic.io.OutputSource;

public class WriterOutputSource
implements OutputSource {
    private final Writer writer;
    private final char[] buf = new char[1024];
    private int pos = 0;

    public WriterOutputSource(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void append(String text) throws IOException {
        this.append(text, 0, text.length());
    }

    @Override
    public void append(String text, int start, int end) throws IOException {
        int length = end - start;
        if (this.pos + length < this.buf.length) {
            text.getChars(start, end, this.buf, this.pos);
            this.pos += length;
            return;
        }
        if (this.pos > 0) {
            this.writer.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        if (length < this.buf.length) {
            text.getChars(start, end, this.buf, 0);
            this.pos = length;
        } else {
            this.writer.write(text, start, length);
        }
    }

    @Override
    public void append(char c) throws IOException {
        if (this.pos + 1 >= this.buf.length) {
            this.writer.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        this.buf[this.pos++] = c;
    }

    @Override
    public void flush() throws IOException {
        if (this.pos > 0) {
            this.writer.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        this.writer.flush();
    }
}

