/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.atrules.css3.media;

import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class MediaOrientation
extends MediaFeature {
    static CssIdent portrait = CssIdent.getIdent("portrait");
    static CssIdent landscape = CssIdent.getIdent("landscape");

    public MediaOrientation() {
    }

    public MediaOrientation(ApplContext ac, String modifier, CssExpression expression, boolean check2) throws InvalidParamException {
        if (modifier != null) {
            throw new InvalidParamException("nomodifiermedia", this.getFeatureName(), ac);
        }
        if (expression != null) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (expression.getCount() == 0) {
                throw new InvalidParamException("few-value", this.getFeatureName(), ac);
            }
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 0: {
                    CssIdent id = (CssIdent)val;
                    if (portrait.equals(id)) {
                        this.value = portrait;
                        break;
                    }
                    if (landscape.equals(id)) {
                        this.value = landscape;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", expression.getValue(), this.getFeatureName(), ac);
                }
            }
        }
    }

    public MediaOrientation(ApplContext ac, String modifier, CssExpression expression) throws InvalidParamException {
        this(ac, modifier, expression, false);
    }

    @Override
    public void setModifier(ApplContext ac, String modifier) throws InvalidParamException {
        throw new InvalidParamException("nomodifiermedia", this.getFeatureName(), ac);
    }

    public Object get() {
        return this.value;
    }

    @Override
    public final String getFeatureName() {
        return "orientation";
    }

    @Override
    public boolean equals(MediaFeature other) {
        try {
            MediaOrientation mo = (MediaOrientation)other;
            return this.value == null && mo.value == null || this.value != null && this.value.equals(mo.value);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

