/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.svg;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssWritingMode
extends org.w3c.css.properties.css.CssWritingMode {
    public static final CssIdent[] allowed_values;

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssWritingMode() {
        this.value = initial;
    }

    public CssWritingMode(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (val.getType() == 0) {
            boolean isCss3 = ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0;
            CssIdent ident = (CssIdent)val;
            if (inherit.equals(ident)) {
                this.value = inherit;
            } else {
                this.value = CssWritingMode.getAllowedIdent(ident);
                CssIdent css3ident = null;
                if (isCss3) {
                    css3ident = org.w3c.css.properties.css3.CssWritingMode.getAllowedIdent(ident);
                }
                if (this.value == null && css3ident == null) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                if (this.value == null) {
                    this.value = css3ident;
                }
                if (css3ident == null && isCss3) {
                    ac.getFrame().addWarning("deprecated", this.getPropertyName());
                }
            }
        } else {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
        expression.next();
    }

    public CssWritingMode(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _allowed_values = new String[]{"lr-tb", "rl-tb", "tb-rl", "lr", "rl", "tb"};
        allowed_values = new CssIdent[_allowed_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssWritingMode.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }
}

