.TH Xlife 6 
.SH NAME
Xlife - Conway's Game of Life, for X
.SH SYNTAX
.B xlife [-geometry string] [initial pattern file]
.SH DESCRIPTION
.NXR "xlife"
.PN xlife
brings up a single window in which the user may experiment interactively with
cellular automata.  In its default mode, the program helps the user play with
John Horton Conway's `Life' game.

By default Xlife will run in a window taking up 4/5ths of your screen; you can
use your window manager's Zoom or Resize feature to make it fill the whole
screen.  This window is a viewport on a universe which is effectively unbounded
(4.2 billion on a side).

The -geometry option sets the Xlife window size and position as per usual for
X applications.

.SH COMMANDS
.IP \fB8\fR 20 
Move your view of the universe up.
.IP \fB2\fR 20 
Move your view of the universe down.
.IP \fB6\fR 20
Move your view of the universe right.
.IP \fB4\fR 20
Move your view of the universe left.
.IP \fB5\fR 20
Center the universe on the screen (based on average position of the cells).
.IP \fB.\fR 20 
Center the universe view on the cursor (also Button 2 in normal mode).
.IP \fB=,+\fR 20
Zoom the view in, magnifying the area around the mouse cursor.
.IP \fB\-\fR 20
Zoom the view out.
.IP \fBg\fR 20
Toggle running the game.
.IP \fBo\fR 20
Step forward one generation.
.IP \fBS\fR 20
Save the universe to a file adding extension .l.  If there is currently 
a boxed pattern, only the boxed pattern is saved.
.IP \fBl\fR 20
Load (actually add to) the universe from a file with extention .l.
This lets you overlay multiple saved states to make for some interesting
effects.  Loaded pattern is initially considered tentative, and
may be manipulated in various ways before incorporating it into main
pattern. (To indicate this, it's surrounded by a bounding box.)
Clear the universe if you want to start from scratch.
Load assumes pattern is in last directory accessed.
.IP \fBh\fR 20
(Hide) stop displaying after each generation, does not iconify.
.IP \fBc\fR 20
Toggle showing of cell counts
.IP \fB?\fR 20
Help for xlife.
.IP \fB!\fR 20
Place random cells on the area of the universe on the screen.
.IP \fBr\fR 20
Redraw the screen.
.IP \fBR\fR 20
Change the (2-state) rules in "stays alive on"/"born on" format. The standard
rules are 23/3 (alive on two or three neighbors, birth on three neighbors for
an empty cell).  Alternatively, enable a payoff matrix with the syntax
<float>$<float> as described in the PRISONER'S DILEMMA section.
.IP \fBF\fR
Load n-state rules from a given file (see the N-STATE SUPPORT section below).
.IP \fBN\fR 20
Change the file's internal name.
.IP \fBA\fR 20
Add comments.
.IP \fBV\fR 20
View comments.
.IP \fBC\fR 20
Clear the universe.  If there is a boxed pattern, clear that instead.
.IP \fBQ\fR 20
Quit
.IP \fBf\fR 20 
Run at a fast speed (no delay)
.IP \fBm\fR 20 
Run at a medium speed
.IP \fBs\fR 20 
Run at a slow speed
.IP \fBp\fR 20 
Toggle running display of mouse position.  Position is only for 
reference during a session, and does not effect 
coordinates of saved points.
.IP \fBO\fR 20 
Set current mouse position to be the origin of displayed coordinates.
.IP \fBG\fR 20 
Generate tentative loaded pattern for one or more steps.
.IP \fBU\fR 20 
Undo load of tentative pattern.
.IP \fBI\fR 20 
Force tentative pattern to be incorporated into main pattern 
(automatic with g, h, o, l, and W commands).
.IP \fBW\fR 20 
Write (and flush from memory) script of loaded patterns 
into a file with '.' 
extension.  When loaded,
this script corresponds the earliest ancestor of current 
pattern that can be reconstructed from loaded patterns (does not included
changes made with mouse).  Origin of written pattern
is mouse position when 'W' is typed.
.IP \fBD\fR 20 
Discard current load script, including any tentative pattern,
but leave cell population intact.  (Helpful for using an old pattern as
a template to construct a load script).

.SH BUTTON BINDINGS IN NORMAL MODE
.IP \fB1\fR 20
Activate a cell at the cursor.
.IP \fB2\fR 20 
Erase any previous selection box.  If you drag the cursor with button 2
held down, then release it, the rectangle between the press and release
points is boxed and made tentative (as though it had just been loaded
and not yet incorporated).  The tentative pattern can then be moved, 
flipped, and rotated before re-incorporating it.
.IP \fB3\fR 20 
Delete a cell at the cursor.

.SH BUTTON BINDINGS WITH TENTATIVE PATTERN LOADED
.IP \fB1\fR 20
Move pattern to current position.
.IP \fB2\fR 20 
Flip pattern about its x-axis.
.IP \fB3\fR 20 
Rotate pattern clockwise about its origin.
.IP "" 0

.SH LOAD FILE FORMAT
A .l image file is an ordinary text file consisting of lines terminated by
the newline character. It is interpreted as one or more image sections
separated by section lines beginning with '#'. Lines led by `##' are
considered comments and ignored.

Each image section is interpreted according to the format letter following its
section line #. The format letters are:

A -- Absolute.
Each line is interpreted as an absolute (x,y) coordinate pair.

R -- Relative.
Each line is interpreted as a relative (x,y) coordinate pair.

P -- Picture.
Each line in the section is interpreted as a scan line of a relative image.
Each '*' character turns the corresponding bit on. All other characters leave
the corresponding bit off.

I -- Include.
A #I line should have whitespace-separated fields after the #I consisting of a
pattern name and five optional integer parameters 
(x, y offsets, rotation, flip, and delay as defined in 
section on inclusion, below). 
The named pattern is loaded as if it had been included in the image at this 
point with the given transformation applied. The
offsets, if present, displace the load point of the pattern relative to the
current mouse position. The include facility is useful for assembling `sampler'
collections of interesting patterns, as well as maintaining structured
representations of complex patterns. 

B and E -- Pattern blocks.  
Patterns enclosed by #B <name> and #E lines are skipped
when loading a whole file, but may be accessed by adding
:<name> to the file name.  They are useful for bundling related patterns 
into the same file.  Access is by sequentially skipping lines not in the 
block, so excessive numbers of blocks in the same file may slow down the
loading process.  Pattern blocks may not be nested.

Relative image sections are normally drawn with 0,0 on the current mouse
position (coordinates may be negative). This may be changed by including a
pair of whitespace-separated integers after the format character. If this is
done, these will be interpreted as a pair of x and y offsets, and the image
section will be drawn with its upper left corner displaced from the cursor
position by those offsets. This facility can be used to write image files
that will load patterns centered on the cursor.

A leading image section with no header line is treated as though it had a `#A'
header. Thus, version 1.00 image files will load properly.

N -- Name
This line contains the internal name of the pattern (which may differ from the
XXX.l name of the file.

O -- Owner
This line contains information on the person who wrote the file, it is written
in the form: id "name"@machine date, for example.

#O jb7m "Jon C. R. Bennett"@sushi.andrew.cmu.edu Fri Jan 12 18:25:54 1990

C -- Comment
Lines begining with "C" are comments that the user may have automatically
writen to the save file, and which may be viewed from within Xlife.

U -- Use
Format is #U followed by a filename. This directive is ignored if Xlife is in
2-state mode.  In N-state mode (see below), it loads a rule-set file just as
if the user had typed in the name.  If the named file is already loaded, it
will not be reloaded.

More section formats may be added in the future. 

.SH PATTERN INCLUSION
The #I command, as described above, has the following format:

	#I <pattern> <x> <y> <rotate> <flip> <delay>

Any prefix of fields that includes a pattern name is acceptable, with the
natural defalts (no delay, no flip, no rotate, no y or x offset).

In the above
.IP "<pattern> 20
is a pattern name (described below);
.IP "<x>,<y> 20
are integers representing horizontal and vertical offsets; and
.IP "<rotate> 20
is an integer that specifies the number of times the pattern is rotated
90 degrees clockwise around the origin.  Any rotation value (positive or 
negative) is acceptable, as all are taken mod 4 (true mod, not "%").
.IP "<flip> 20
is a multiplier (1 or -1) for the y coordinate that specifies a flip 
about the x-axis.  Other integers are accepted and silently mapped  to 1.
.IP "<delay> 20
is an integer specifying the number of generations to perform before 
loading the pattern (negative values have same effect as 0).

Note that all of the transformations applied to an included pattern are taken 
relative to the pattern that includes it.  Thus, loading an assemblage of
included patterns works as one would expect.

A pattern name takes one of the following three forms:
.IP <file> 20
include whole file <file> (like old format)
.IP <file>:<name> 20
include pattern block <name> in <file> 
.IP :<name> 20
include pattern block <name> in current file 

(Note that <file>: is not allowed.)
.IP "" 0

A file may also include literal or pattern blocks.
A pattern block is a pattern given in any acceptable format between a line
containing "#B <name>" and another line containing "#E".  Pattern blocks
are skipped when including a whole file.  

(Note that pattern blocks \fUcannot\fR be nested.)

.SH N-STATE SUPPORT

Xlife includes support for automata with up to 8 states using
the (von-Neumann-style) 4-cell rotationally symmetric neighborhood; to
invoke it, load a rule-set file using the `F' command.  Many
interesting automata including the Wireworld construct and the UCC
described in E. F. Codd's 1968 ACM monograph can be implemented by
specifying appropriate transition functions.

When Xlife is used in this mode, the program uses color to indicate states.
Pattern picture files may contain digits to specify the states of picture
cells; `*' is interpreted as 1.  Color-picker radio buttons are set up at
the right-hand side of the input window; by clicking your cursor on
a button, you set button 1 to paint with that color.  You can return
to 2-state mode with the `R' command.

Refer to the rule-set file `codd.r' for an example of transition
definition syntax.  Each line contains either a directive or 6 digits
arranged as

<old-state><neighbor><neighbor><neighbor><neighbor><new-state>

For <old-state> or <neighbor> you may also specify a \fIstate set\fR; digits
enclosed in square brackets. This wild-cards the transition in the obvious
way. Comments (begun with `#') are permitted in the file.

You can arrange for rulesets to be loaded automatically by putting a `#U' 
directive in a pattern file.  When you save a pattern, a #U is automatically
generated into the save file giving the name of the current ruleset.

The directive

	states <maxstates>

tells the code what the automaton's count of cell states is.  The default is 8.

If, while evolving a pattern, the code finds a cell and neighborhood in a state
for which no transition has been specified, the program queries the user for
a new state, and the tuple implied is added to the database. This behavior
can be modified by including a line of the form

	passive <maxstate>

which instructs the code that all combinations of cell and neighbor states up
to and including <maxstate> for which there is no explicit rule leave the cell
status unchanged.  A `passive' declaration in a rules file can be partially
overridden by later, explicit transition rules.

You can also specify rules depending on a neighbor count.  A rule line of the
form 

	S(N*C)R

with S, N, C, and R being digits, is interpreted to mean that if a cell has
state S and exactly C neighbors of state N, the result state is R. For an
example of usage, see the Wireworld rules file.

When the evolution function encounters a neighborhood for which there is no
defined transition, it stops and boxes that neighborhood.  You are prompted 
for a result state.  Once you've entered it, the evolution function continues
and the new transition rule is appended to a new-transitions file in the
current directory.

.SH PRISONER'S DILEMMA MODELS

In the June 1995 Scientific American, the article "The Arithmetic of Mutual"
Help" (by Martin A. Nowak, Robert M. May and Karl Sigmund) describes an
interesting class of cellular automata that model iterated Prisoner's Dilemma
situations.  These games can illustrate stable and winning cooperate/defect
strategies for situations in which each agent repeatedly interacts with near
neighbors.  In the same issue, Alun L. Lloyd's "Mathematical Games" column
goes into more detail about these simulations.

These are two-state automata.  In Alun's implementation one state always
cooperates, one always defects (higher states could model Tit-for-Tat,
Generous Tit-for-Tat, or Pavlov).  There is a payoff matrix of the following
form:

.TS
center box tab(;);
l | c c.
Payoff;Cooperate;Defect
_
Cooperate;1;a;
Defect;b;0
.TE

To make the game interesting, b must be greater than 1.  (Lloyd's simulation
only considers the case a = 0.)  On each round, each cell first plays the game
with each of its neighbors in turn.  Then, each cell looks at the payoffs of
its neighbors (and its own payoff) and switches to the strategy with the
highest payoff).

To set up such a game, use the `R' command in the following form:

	R<b>$<a>

For example, to set up Lloyd's simulation, do `R1.85$0'.  In these 
simulations, use the following mapping between states and strategies:
.TP 0
0
Quiescent.
.TP 0
1
Live, always cooperates.
.TP 0
2
Live, always defects.

Interesting b values are in the range (1, 2]; Lloyd likes 1.85.  Different
values produce wide ranges of different behaviors, including stable end
states, statistical equilibria and cycles with large swings.  Initial
clustering of cooperators is also important; a single cooperator will 
always be snuffed by surrounding defectors, but a block of 4 or more may
be able to defend themselves and earn a high enough relative payoff to
convert neighbors.

Lloyd included illustrations of a 1.85 game starting with one defector in a sea
of cooperators.  The resulting patterns look like Persian carpets or Koch
snowflake curves.

.SH OTHER FEATURES OF RULE FILES AND EDITING

The directive

	debug 1

will enable single-step debugging of pattern evolution (so you can watch the
transition function being applied).  Diagnostic messages will be sent to
stderr.

Transition rules entered interactively are appended (commented with user
ID and timestamp) to the file \fBnew.transitions\fR in the current directory.
This file can later be selectively merged with your original ruleset using 
a text editor.

.SH ENVIRONMENT
The program has a compiled-in default for its global pattern directory,
LIFEDIR, which is normally /usr/local/lib/xlife.

If the the variable LIFEPATH is set to a colon-separated list of directories,
these directories (and their first-level subdirectories) will be searched for
pattern-file names and rulesets.  The default list includes "." and LIFEDIR;
that is, pattern files are searched for, by default, below the current
directory and below the global pattern directory.

The recommended way to organize your pattern directories is to have one
subdirectory per automaton.  The distribution provides the following:  
.TP 0
life
contains an extensive library of interesting Life patterns.
.TP 0
codd
contains transition rules and components for the universal
computer-constructor described in E.F Codd's
.I Cellular Automata
Academic Press 1968 (ACM Monograph #3).
.TP 0
wireworld
contains transition rules and a test pattern for the Wireworld automaton
as described in the January 1990 issue of Scientific American (Computer
Recreations, p. 146).
.TP 0
misc
contains patterns for miscellaneous other automata.

These will be copied under LIFEDIR by a normal installation.
.SH EXPLORATION
Here are some 2-state rules to experiment with:
.IP 23/3 20
the default, of course; Conway's "Life" rules.
.IP 1234/3 20
patterns "crystallize"
.IP 12345/45 20
patterns become contained
.IP 12345/4 20
same as above, but settles VERY quickly
.IP 5/12 20
floor tile patterns... Variations of this tend to be interesting as well.
.IP /2 20
most patterns expand indefinitely, some interesting ones. Fast gliders.

.SH BUGS
Old files in #P format may not have same y coordinate when read by the
new release.  For best results, use "lifeconv -p name ..." on old files. 

Expose events don't restore the tentative pattern.

.SH AUTHORS
Algorithm, implementation and file format enhancements:
	Jon Bennett <jcrb@cs.cmu.edu>

Original X code:
	Chuck Silvers <cs4n@andrew.cmu.edu>

Enhancements to #I format and user interface:
	Paul Callahan <callahan@cs.jhu.edu>

Auto-sizing, load format enhancements, 8-state support, all of the non-Life
automata, still-life detection, boxing:
	Eric S. Raymond <esr@snark.thyrsus.com>

.SH SEE ALSO   
lifesearch(1), lifeconv(1). 
.\"
.\"The following sets edit modes for GNU EMACS
.\"Local Variables:
.\"mode:nroff
.\"fill-column:79
.\"End:
