/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

public class PayloadArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter converter;
    private final Validator validator;

    public PayloadArgumentResolver(MessageConverter messageConverter) {
        this(messageConverter, null);
    }

    public PayloadArgumentResolver(MessageConverter messageConverter, Validator validator) {
        Assert.notNull(messageConverter, "MessageConverter must not be null");
        this.converter = messageConverter;
        this.validator = validator;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return true;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Payload ann = parameter.getParameterAnnotation(Payload.class);
        if (ann != null && StringUtils.hasText(ann.value())) {
            throw new IllegalStateException("@Payload SpEL expressions not supported by this resolver");
        }
        Object payload = message.getPayload();
        if (this.isEmptyPayload(payload)) {
            if (ann == null || ann.required()) {
                String paramName = this.getParameterName(parameter);
                BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(payload, paramName);
                bindingResult.addError(new ObjectError(paramName, "Payload value must not be empty"));
                throw new MethodArgumentNotValidException(message, parameter, bindingResult);
            }
            return null;
        }
        Class<?> targetClass = parameter.getParameterType();
        if (ClassUtils.isAssignable(targetClass, payload.getClass())) {
            this.validate(message, parameter, payload);
            return payload;
        }
        payload = this.converter.fromMessage(message, targetClass);
        if (payload == null) {
            throw new MessageConversionException(message, "No converter found to convert to " + targetClass + ", message=" + message);
        }
        this.validate(message, parameter, payload);
        return payload;
    }

    private String getParameterName(MethodParameter param) {
        String paramName = param.getParameterName();
        return paramName != null ? paramName : "Arg " + param.getParameterIndex();
    }

    protected boolean isEmptyPayload(Object payload) {
        if (payload == null) {
            return true;
        }
        if (payload instanceof byte[]) {
            return ((byte[])payload).length == 0;
        }
        if (payload instanceof String) {
            return !StringUtils.hasText((String)payload);
        }
        return false;
    }

    protected void validate(Message<?> message, MethodParameter parameter, Object target) {
        if (this.validator == null) {
            return;
        }
        for (Annotation ann : parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = AnnotationUtils.getAnnotation(ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue(ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(target, this.getParameterName(parameter));
            if (!ObjectUtils.isEmpty(validationHints) && this.validator instanceof SmartValidator) {
                ((SmartValidator)this.validator).validate(target, bindingResult, validationHints);
            } else {
                this.validator.validate(target, bindingResult);
            }
            if (!bindingResult.hasErrors()) break;
            throw new MethodArgumentNotValidException(message, parameter, bindingResult);
        }
    }
}

