/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractExceptionHandlerMethodResolver {
    private static final Method NO_METHOD_FOUND = ClassUtils.getMethodIfAvailable(System.class, "currentTimeMillis", new Class[0]);
    private final Map<Class<? extends Throwable>, Method> mappedMethods = new ConcurrentHashMap<Class<? extends Throwable>, Method>(16);
    private final Map<Class<? extends Throwable>, Method> exceptionLookupCache = new ConcurrentHashMap<Class<? extends Throwable>, Method>(16);

    protected AbstractExceptionHandlerMethodResolver(Map<Class<? extends Throwable>, Method> mappedMethods) {
        Assert.notNull(mappedMethods, "Mapped Methods must not be null");
        this.mappedMethods.putAll(mappedMethods);
    }

    protected static List<Class<? extends Throwable>> getExceptionsFromMethodSignature(Method method) {
        ArrayList<Class<? extends Throwable>> result = new ArrayList<Class<? extends Throwable>>();
        for (Class<?> paramType : method.getParameterTypes()) {
            if (!Throwable.class.isAssignableFrom(paramType)) continue;
            result.add(paramType);
        }
        Assert.notEmpty(result, "No exception types mapped to {" + method + "}");
        return result;
    }

    public boolean hasExceptionMappings() {
        return this.mappedMethods.size() > 0;
    }

    public Method resolveMethod(Exception exception) {
        Class<?> exceptionType = exception.getClass();
        Method method = this.exceptionLookupCache.get(exceptionType);
        if (method == null) {
            method = this.getMappedMethod(exceptionType);
            this.exceptionLookupCache.put(exceptionType, method != null ? method : NO_METHOD_FOUND);
        }
        return method != NO_METHOD_FOUND ? method : null;
    }

    private Method getMappedMethod(Class<? extends Exception> exceptionType) {
        ArrayList<Class<? extends Throwable>> matches = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> mappedException : this.mappedMethods.keySet()) {
            if (!mappedException.isAssignableFrom(exceptionType)) continue;
            matches.add(mappedException);
        }
        if (!matches.isEmpty()) {
            Collections.sort(matches, new ExceptionDepthComparator(exceptionType));
            return this.mappedMethods.get(matches.get(0));
        }
        return null;
    }
}

