/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.swingui.ChangeListeningDataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelChangeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class TabbedDataEntryPanel
extends ChangeListeningDataEntryPanel
implements ChangeListeningDataEntryPanel.ErrorTextListener {
    private static final Logger logger = Logger.getLogger(TabbedDataEntryPanel.class);
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final List<DataEntryPanel> panels = new ArrayList<DataEntryPanel>();

    public void addTab(String name, DataEntryPanel panel) {
        this.tabbedPane.addTab(name, panel.getPanel());
        this.panels.add(panel);
        if (panel instanceof ChangeListeningDataEntryPanel) {
            ((ChangeListeningDataEntryPanel)panel).addErrorTextListener((ChangeListeningDataEntryPanel.ErrorTextListener)this);
        }
    }

    public boolean applyChanges() {
        logger.debug((Object)"Applying changes...");
        boolean success = true;
        for (DataEntryPanel panel : this.panels) {
            logger.debug((Object)("       ... on " + panel));
            success &= panel.applyChanges();
        }
        return success;
    }

    public void discardChanges() {
        for (DataEntryPanel panel : this.panels) {
            panel.discardChanges();
        }
    }

    public JComponent getPanel() {
        return this.tabbedPane;
    }

    public boolean hasUnsavedChanges() {
        for (DataEntryPanel panel : this.panels) {
            if (!panel.hasUnsavedChanges()) continue;
            return true;
        }
        return false;
    }

    public void textChanged(String s) {
        this.setErrorText(s);
        for (DataEntryPanel p : this.panels) {
            int index;
            String errorText;
            if (!(p instanceof ChangeListeningDataEntryPanel) || (errorText = ((ChangeListeningDataEntryPanel)p).getErrorText()) == null || errorText.equals("") || (index = this.tabbedPane.indexOfComponent(p.getPanel())) < 0) continue;
            this.tabbedPane.setBackgroundAt(index, DataEntryPanelChangeUtil.DARK_NONCONFLICTING_COLOR);
        }
    }
}

