/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.SQLObjectComboBoxModel;
import ca.sqlpower.architect.swingui.olap.OLAPObjectNameValidator;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.FormValidationHandler;
import ca.sqlpower.validation.swingui.NotNullValidator;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidatableDataEntryPanel;
import ca.sqlpower.validation.swingui.ValidationHandler;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HierarchyEditPanel
implements ValidatableDataEntryPanel {
    private final MondrianModel.Hierarchy hierarchy;
    private final JPanel panel;
    private final JTextField name;
    private final JTextField captionField;
    private final JComboBox tableChooser;
    private final JCheckBox hasAll;
    private final JTextField allLevelName;
    private final JComboBox primaryKey;
    private FormValidationHandler handler;
    private StatusComponent status = new StatusComponent();

    public HierarchyEditPanel(MondrianModel.Hierarchy hierarchy) throws SQLObjectException {
        this.hierarchy = hierarchy;
        List<SQLTable> tables = OLAPUtil.getAvailableTables(hierarchy);
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 80dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.status, 3);
        this.name = new JTextField(hierarchy.getName());
        builder.append("Name", (Component)this.name);
        this.captionField = new JTextField(hierarchy.getCaption());
        builder.append("Caption", (Component)this.captionField);
        this.hasAll = new JCheckBox();
        builder.append("Has All", (Component)this.hasAll);
        this.hasAll.setSelected(hierarchy.getHasAll() != null ? hierarchy.getHasAll() : true);
        this.allLevelName = new JTextField(hierarchy.getAllLevelName() != null ? hierarchy.getAllLevelName() : "All");
        builder.append("All Level Name", (Component)this.allLevelName);
        this.tableChooser = new JComboBox<SQLTable>(new Vector<SQLTable>(tables));
        builder.append("Table", this.tableChooser);
        this.primaryKey = new JComboBox();
        builder.append("Primary Key", this.primaryKey);
        if (tables.isEmpty()) {
            this.tableChooser.addItem("Database has no tables");
            this.tableChooser.setEnabled(false);
            this.primaryKey.addItem("Table not selected");
            this.primaryKey.setEnabled(false);
        } else {
            SQLTable t = OLAPUtil.tableForHierarchy(hierarchy);
            if (tables.contains(t)) {
                this.tableChooser.setSelectedItem(t);
            } else {
                t = (SQLTable)this.tableChooser.getSelectedItem();
            }
            this.updateColumns(hierarchy.getPrimaryKey());
        }
        this.tableChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HierarchyEditPanel.this.updateColumns(null);
            }
        });
        this.handler = new FormValidationHandler(this.status, true);
        OLAPObjectNameValidator validator = new OLAPObjectNameValidator((OLAPObject)hierarchy.getParent(), hierarchy, true);
        this.handler.addValidateObject((JComponent)this.name, (Validator)validator);
        this.handler.addValidateObject((JComponent)this.primaryKey, (Validator)new NotNullValidator("Primary key"));
        this.panel = builder.getPanel();
    }

    private void updateColumns(String primaryKeyName) {
        SQLTable selectedTable = (SQLTable)this.tableChooser.getSelectedItem();
        boolean enableColumns = false;
        try {
            if (selectedTable.getColumns().isEmpty()) {
                this.primaryKey.addItem("Table has no columns");
            } else {
                this.primaryKey.setSelectedItem(null);
                this.primaryKey.setModel(new SQLObjectComboBoxModel((SQLObject)selectedTable, SQLColumn.class));
                for (SQLColumn col : selectedTable.getColumns()) {
                    if (!col.getName().equalsIgnoreCase(primaryKeyName)) continue;
                    this.primaryKey.setSelectedItem(col);
                }
                enableColumns = true;
            }
            this.primaryKey.setEnabled(enableColumns);
        }
        catch (SQLObjectException ex) {
            throw new SQLObjectRuntimeException(ex);
        }
    }

    public boolean applyChanges() {
        this.hierarchy.begin("Modify hierarchy properties");
        if (!this.name.getText().equals("")) {
            this.hierarchy.setName(this.name.getText());
        } else {
            this.hierarchy.setName(null);
        }
        if (!this.captionField.getText().equals("")) {
            this.hierarchy.setCaption(this.captionField.getText());
        } else {
            this.hierarchy.setCaption(null);
        }
        this.hierarchy.setHasAll(this.hasAll.isSelected());
        this.hierarchy.setAllLevelName(this.allLevelName.getText());
        if (this.tableChooser.isEnabled()) {
            SQLTable t = (SQLTable)this.tableChooser.getSelectedItem();
            MondrianModel.Table table = new MondrianModel.Table();
            table.setName(t.getName());
            table.setSchema(OLAPUtil.getQualifier(t));
            this.hierarchy.setRelation(table);
            if (this.primaryKey.isEnabled()) {
                SQLColumn column = (SQLColumn)this.primaryKey.getSelectedItem();
                this.hierarchy.setPrimaryKey(column.getName());
            }
        }
        this.hierarchy.commit();
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public ValidationHandler getValidationHandler() {
        return this.handler;
    }
}

