/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;

public class ObjectType
implements Type {
    public static final ObjectType TYPE_BOOLEAN = new ObjectType("java/lang/Boolean", "java.lang.Boolean", "Boolean");
    public static final ObjectType TYPE_BYTE = new ObjectType("java/lang/Byte", "java.lang.Byte", "Byte");
    public static final ObjectType TYPE_CHARACTER = new ObjectType("java/lang/Character", "java.lang.Character", "Character");
    public static final ObjectType TYPE_CLASS = new ObjectType("java/lang/Class", "java.lang.Class", "Class");
    public static final ObjectType TYPE_DOUBLE = new ObjectType("java/lang/Double", "java.lang.Double", "Double");
    public static final ObjectType TYPE_FLOAT = new ObjectType("java/lang/Float", "java.lang.Float", "Float");
    public static final ObjectType TYPE_INTEGER = new ObjectType("java/lang/Integer", "java.lang.Integer", "Integer");
    public static final ObjectType TYPE_MATH = new ObjectType("java/lang/Math", "java.lang.Math", "Math");
    public static final ObjectType TYPE_OBJECT = new ObjectType("java/lang/Object", "java.lang.Object", "Object");
    public static final ObjectType TYPE_SHORT = new ObjectType("java/lang/Short", "java.lang.Short", "Short");
    public static final ObjectType TYPE_STRING = new ObjectType("java/lang/String", "java.lang.String", "String");
    public static final ObjectType TYPE_THROWABLE = new ObjectType("java/lang/Throwable", "java.lang.Throwable", "Throwable");
    public static final ObjectType TYPE_UNDEFINED_OBJECT = new ObjectType("java/lang/Object", "java.lang.Object", "Object"){

        @Override
        public String toString() {
            return "UndefinedObjectType";
        }
    };
    protected String internalName;
    protected String qualifiedName;
    protected String name;
    protected BaseTypeArgument typeArguments;
    protected int dimension;
    protected String descriptor;

    public ObjectType(String internalName, String qualifiedName, String name) {
        this(internalName, qualifiedName, name, null, 0);
    }

    public ObjectType(String internalName, String qualifiedName, String name, int dimension) {
        this(internalName, qualifiedName, name, null, dimension);
    }

    public ObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments) {
        this(internalName, qualifiedName, name, typeArguments, 0);
    }

    public ObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments, int dimension) {
        this.internalName = internalName;
        this.qualifiedName = qualifiedName;
        this.name = name;
        this.typeArguments = typeArguments;
        this.dimension = dimension;
        assert (internalName != null && !internalName.endsWith(";"));
        switch (dimension) {
            case 0: {
                this.descriptor = "L" + internalName + ';';
                break;
            }
            case 1: {
                this.descriptor = "[L" + internalName + ';';
                break;
            }
            case 2: {
                this.descriptor = "[[L" + internalName + ';';
                break;
            }
            default: {
                this.descriptor = new String(new char[dimension]).replaceAll("\u0000", "[") + 'L' + internalName + ';';
            }
        }
    }

    public ObjectType(ObjectType ot) {
        this.internalName = ot.getInternalName();
        this.qualifiedName = ot.getQualifiedName();
        this.name = ot.getName();
        this.typeArguments = ot.getTypeArguments();
        this.dimension = ot.getDimension();
        this.descriptor = ot.getDescriptor();
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public BaseTypeArgument getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Type createType(int dimension) {
        assert (dimension >= 0);
        if (this.dimension == dimension) {
            return this;
        }
        return new ObjectType(this.internalName, this.qualifiedName, this.name, this.typeArguments, dimension);
    }

    public ObjectType createType(BaseTypeArgument typeArguments) {
        return new ObjectType(this.internalName, this.qualifiedName, this.name, typeArguments, this.dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        return this.internalName.equals(that.internalName);
    }

    public int hashCode() {
        int result = this.internalName.hashCode();
        result = 31 * result + this.dimension;
        return result;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ObjectType{");
        sb.append(this.internalName);
        if (this.typeArguments != null) {
            sb.append('<').append(this.typeArguments).append('>');
        }
        if (this.dimension > 0) {
            sb.append(", dimension=").append(this.dimension);
        }
        return sb.append('}').toString();
    }
}

