/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.pfm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFont;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFontRecord;
import org.pentaho.reporting.libraries.fonts.registry.AbstractFontFileRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PfmFontRegistry
extends AbstractFontFileRegistry {
    private static final Log logger = LogFactory.getLog(PfmFontRegistry.class);
    private static final FontPathFilter FONTPATHFILTER = new FontPathFilter();
    private HashMap fontFamilies = new HashMap();
    private HashMap alternateFamilyNames = new HashMap();
    private HashMap fullFontNames = new HashMap();
    private boolean itextCompatibleChecks = true;

    public boolean isItextCompatibleChecks() {
        return this.itextCompatibleChecks;
    }

    public void setItextCompatibleChecks(boolean itextCompatibleChecks) {
        this.itextCompatibleChecks = itextCompatibleChecks;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FONTPATHFILTER;
    }

    @Override
    public FontMetricsFactory createMetricsFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FontCache getSecondLevelCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addFont(File font, String encoding) throws IOException {
        String fileName = font.getCanonicalPath();
        String filePfbName = fileName.substring(0, fileName.length() - 3) + "pfb";
        File filePfb = new File(filePfbName);
        boolean embedded = true;
        if (!(filePfb.exists() && filePfb.isFile() && filePfb.canRead())) {
            logger.warn((Object)("Cannot embedd font: " + filePfb + " is missing for " + font));
            embedded = false;
        }
        PfmFont pfmFont = new PfmFont(font, embedded);
        if (this.itextCompatibleChecks && !pfmFont.isItextCompatible()) {
            logger.warn((Object)("Cannot embedd font: pfb-file for " + font + " is not valid (according to iText)."));
        }
        this.registerFont(pfmFont);
        pfmFont.dispose();
        return true;
    }

    private void registerFont(PfmFont font) throws IOException {
        String windowsName = font.getFamilyName();
        String postscriptName = font.getFontName();
        DefaultFontFamily fontFamily = this.createFamily(windowsName);
        this.alternateFamilyNames.put(windowsName, fontFamily);
        this.alternateFamilyNames.put(postscriptName, fontFamily);
        this.fullFontNames.put(windowsName, fontFamily);
        this.fullFontNames.put(postscriptName, fontFamily);
        PfmFontRecord record = new PfmFontRecord(font, fontFamily);
        fontFamily.addFontRecord(record);
    }

    private DefaultFontFamily createFamily(String name) {
        DefaultFontFamily fontFamily = (DefaultFontFamily)this.fontFamilies.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        DefaultFontFamily createdFamily = new DefaultFontFamily(name);
        this.fontFamilies.put(name, createdFamily);
        return createdFamily;
    }

    @Override
    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    @Override
    public String[] getAllRegisteredFamilies() {
        return this.alternateFamilyNames.keySet().toArray(new String[this.alternateFamilyNames.size()]);
    }

    @Override
    public FontFamily getFontFamily(String name) {
        FontFamily primary = (FontFamily)this.fontFamilies.get(name);
        if (primary != null) {
            return primary;
        }
        FontFamily secondary = (FontFamily)this.alternateFamilyNames.get(name);
        if (secondary != null) {
            return secondary;
        }
        return (FontFamily)this.fullFontNames.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFromCache(String encoding) {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        File location = this.createStorageLocation();
        if (location == null) {
            return;
        }
        File ttfCache = new File(location, "afm-fontcache.ser");
        try {
            HashMap cachedAlternateNames;
            HashMap cachedFullFontNames;
            HashMap cachedFontFamilies;
            HashMap cachedSeenFiles;
            ResourceKey resourceKey = resourceManager.createKey((Object)ttfCache);
            ResourceData data = resourceManager.load(resourceKey);
            InputStream stream = data.getResourceAsStream(resourceManager);
            try {
                ObjectInputStream oin = new ObjectInputStream(stream);
                Object[] cache = (Object[])oin.readObject();
                if (cache.length != 5) {
                    return;
                }
                if (!ObjectUtilities.equal((Object)encoding, (Object)cache[0])) {
                    return;
                }
                cachedSeenFiles = (HashMap)cache[1];
                cachedFontFamilies = (HashMap)cache[2];
                cachedFullFontNames = (HashMap)cache[3];
                cachedAlternateNames = (HashMap)cache[4];
            }
            finally {
                stream.close();
            }
            if (this.isCacheValid(cachedSeenFiles)) {
                this.getSeenFiles().putAll(cachedSeenFiles);
                this.fontFamilies.putAll(cachedFontFamilies);
                this.fullFontNames.putAll(cachedFullFontNames);
                this.alternateFamilyNames.putAll(cachedAlternateNames);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to restore the cache:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeToCache(String encoding) {
        File location = this.createStorageLocation();
        if (location == null) {
            return;
        }
        location.mkdirs();
        if (!location.exists() || !location.isDirectory()) {
            return;
        }
        File ttfCache = new File(location, "afm-fontcache.ser");
        try {
            FileOutputStream fout = new FileOutputStream(ttfCache);
            try {
                Object[] map = new Object[]{encoding, this.getSeenFiles(), this.fontFamilies, this.fullFontNames, this.alternateFamilyNames};
                ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(fout));
                objectOut.writeObject(map);
                objectOut.close();
            }
            finally {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    logger.debug((Object)"Failed to store cached font data", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to store cached font data", (Throwable)e);
        }
    }

    private static class FontPathFilter
    implements FileFilter {
        protected FontPathFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            return StringUtils.endsWithIgnoreCase((String)name, (String)".pfm");
        }
    }
}

