/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lucee.loader.util.Util;

public class ZipUtil {
    public static void zip(File src, File trgZipFile) throws IOException {
        if (trgZipFile.isDirectory()) {
            throw new IllegalArgumentException("argument trgZipFile is the name of a existing directory");
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(trgZipFile));
        try {
            if (src.isFile()) {
                ZipUtil.addEntries(zos, src.getParentFile(), src);
            } else if (src.isDirectory()) {
                ZipUtil.addEntries(zos, src, src.listFiles());
            }
        }
        finally {
            Util.closeEL(zos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntries(ZipOutputStream zos, File root, File ... files) throws IOException {
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ZipUtil.addEntries(zos, root, file.listFiles());
                    continue;
                }
                if (!file.isFile()) continue;
                FileInputStream is = null;
                ZipEntry ze = ZipUtil.generateZipEntry(root, file);
                try {
                    zos.putNextEntry(ze);
                    is = new FileInputStream(file);
                    ZipUtil.copy(is, zos);
                }
                catch (Throwable throwable) {
                    ZipUtil.closeEL(is);
                    zos.closeEntry();
                    throw throwable;
                }
                ZipUtil.closeEL(is);
                zos.closeEntry();
            }
        }
    }

    private static ZipEntry generateZipEntry(File root, File file) {
        String strRoot = root.getAbsolutePath();
        String strFile = file.getAbsolutePath();
        return new ZipEntry(strFile.substring(strRoot.length() + 1, strFile.length()));
    }

    private static final void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[65535];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    private static void closeEL(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

