/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGGroupFigure
extends GroupFigure
implements SVGFigure {
    private HashMap<AttributeKey, Object> attributes = new HashMap();

    public SVGGroupFigure() {
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    public <T> void set(AttributeKey<T> attributeKey, T t) {
        if (attributeKey == SVGAttributeKeys.OPACITY) {
            this.attributes.put(attributeKey, t);
        } else if (attributeKey == SVGAttributeKeys.LINK || attributeKey == SVGAttributeKeys.LINK_TARGET) {
            this.attributes.put(attributeKey, t);
        } else {
            super.set(attributeKey, t);
        }
        this.invalidate();
    }

    @Override
    public <T> T get(AttributeKey<T> attributeKey) {
        return attributeKey.get(this.attributes);
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    public void setAttributes(Map<AttributeKey, Object> map) {
        for (Map.Entry<AttributeKey, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        double d = this.get(SVGAttributeKeys.OPACITY);
        if ((d = Math.min(Math.max(0.0, d), 1.0)) != 0.0) {
            if (d != 1.0) {
                Rectangle2D.Double double_ = this.getDrawingArea();
                Rectangle rectangle = graphics2D.getClipBounds();
                if (rectangle != null) {
                    Rectangle2D.intersect(double_, rectangle, double_);
                }
                if (!double_.isEmpty()) {
                    BufferedImage bufferedImage = new BufferedImage(Math.max(1, (int)((2.0 + double_.width) * graphics2D.getTransform().getScaleX())), Math.max(1, (int)((2.0 + double_.height) * graphics2D.getTransform().getScaleY())), 2);
                    Graphics2D graphics2D2 = bufferedImage.createGraphics();
                    graphics2D2.scale(graphics2D.getTransform().getScaleX(), graphics2D.getTransform().getScaleY());
                    graphics2D2.translate((int)(-double_.x), (int)(-double_.y));
                    graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
                    super.draw(graphics2D2);
                    graphics2D2.dispose();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d));
                    graphics2D.drawImage(bufferedImage, (int)double_.x, (int)double_.y, 2 + (int)double_.width, 2 + (int)double_.height, null);
                    graphics2D.setComposite(composite);
                }
            } else {
                super.draw(graphics2D);
            }
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.cachedBounds == null) {
            if (this.getChildCount() == 0) {
                this.cachedBounds = new Rectangle2D.Double();
            } else {
                for (Figure figure : this.children) {
                    Rectangle2D.Double double_ = figure.getBounds();
                    if (figure.get(SVGAttributeKeys.TRANSFORM) != null) {
                        double_.setRect(((AffineTransform)figure.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(double_).getBounds2D());
                    }
                    if (this.cachedBounds == null) {
                        this.cachedBounds = double_;
                        continue;
                    }
                    this.cachedBounds.add(double_);
                }
            }
        }
        return (Rectangle2D.Double)this.cachedBounds.clone();
    }

    public LinkedList<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n) {
            case -1: {
                TransformHandleKit.addGroupHoverHandles(this, linkedList);
                break;
            }
            case 0: {
                TransformHandleKit.addGroupTransformHandles(this, linkedList);
                linkedList.add(new LinkHandle(this));
            }
        }
        return linkedList;
    }

    @Override
    public final void write(DOMOutput dOMOutput) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableOutput to write this Figure.");
    }

    @Override
    public final void read(DOMInput dOMInput) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableInput to read this Figure.");
    }

    @Override
    public boolean isEmpty() {
        return this.getChildCount() == 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        stringBuilder.append('@');
        stringBuilder.append(this.hashCode());
        if (this.getChildCount() > 0) {
            stringBuilder.append('(');
            Iterator<Figure> iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                Figure figure = iterator.next();
                stringBuilder.append(figure);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public SVGGroupFigure clone() {
        SVGGroupFigure sVGGroupFigure = (SVGGroupFigure)super.clone();
        sVGGroupFigure.attributes = new HashMap<AttributeKey, Object>(this.attributes);
        return sVGGroupFigure;
    }
}

