/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;

@Embeddable
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class NetworkAddress {
    @Transient
    public abstract InetAddress getInetAddress();

    public static NetworkAddress getNetworkAddress(InetAddress inetAddress, int prefixLength) throws UnknownHostException {
        if (inetAddress instanceof Inet4Address) {
            return new Network4Address((Inet4Address)inetAddress, prefixLength);
        }
        return new Network6Address((Inet6Address)inetAddress, prefixLength);
    }

    public static NetworkAddress getNetworkAddress(String address, int prefixLength) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(address);
        if (inetAddress instanceof Inet4Address) {
            return new Network4Address((Inet4Address)inetAddress, prefixLength);
        }
        return new Network6Address((Inet6Address)inetAddress, prefixLength);
    }

    public static NetworkAddress getNetworkAddress(String address) throws UnknownHostException {
        return NetworkAddress.getNetworkAddress(address, 0);
    }

    @Transient
    @XmlElement
    public abstract String getIp();

    @Transient
    @XmlElement
    public abstract int getPrefixLength();

    @Transient
    public abstract String getPrefix();

    public String toString() {
        return this.getPrefix();
    }

    public abstract AddressUsage getAddressUsage();

    public abstract void setAddressUsage(AddressUsage var1);

    public static enum AddressUsage {
        PRIMARY,
        SECONDARY,
        VRRP,
        HSRP,
        SECONDARYVRRP,
        SECONDARYHSRP;

    }
}

