/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.diagnostic;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.diagnostic.Diagnostic;
import onl.netfishers.netshot.diagnostic.DiagnosticResult;

@Entity
@DiscriminatorValue(value="B")
public class DiagnosticBinaryResult
extends DiagnosticResult {
    private Boolean assumption;

    protected DiagnosticBinaryResult() {
    }

    public DiagnosticBinaryResult(Device device, Diagnostic diagnostic, boolean value) {
        super(device, diagnostic);
        this.assumption = value;
    }

    public DiagnosticBinaryResult(Device device, Diagnostic diagnostic, String value) {
        super(device, diagnostic);
        this.assumption = true;
        if (value == null || "false".equals(value) || "FALSE".equals(value) || "False".equals(value) || "0".equals(value)) {
            this.assumption = false;
        }
    }

    @XmlElement
    public Boolean getAssumption() {
        return this.assumption;
    }

    public void setAssumption(Boolean assumption) {
        this.assumption = assumption;
    }

    @Override
    @Transient
    public String getAsText() {
        if (Boolean.TRUE == this.assumption) {
            return "true";
        }
        return "false";
    }

    @Override
    @Transient
    public Object getData() {
        return this.getAssumption();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.assumption == null ? 0 : this.assumption.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DiagnosticBinaryResult)) {
            return false;
        }
        DiagnosticBinaryResult other = (DiagnosticBinaryResult)obj;
        return !(this.assumption == null ? other.assumption != null : !this.assumption.equals(other.assumption));
    }
}

