/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.1lf, -1.2lf) * dmat3x2(0.09lf, -1.19lf, 1.3lf, 0.08lf, 1.25lf, 1.08lf)) => dvec3(1.4189999999999998lf, -0.226lf, -1.421lf)
 * (dvec2(-0.1lf, -1.2lf) * dmat3x2(-0.36lf, -0.53lf, -1.08lf, 0.88lf, -0.6lf, -1.79lf)) => dvec3(0.672lf, -0.948lf, 2.208lf)
 * (dvec2(-0.42lf, 0.48lf) * dmat3x2(0.09lf, -1.19lf, 1.3lf, 0.08lf, 1.25lf, 1.08lf)) => dvec3(-0.609lf, -0.5076lf, -0.006599999999999965lf)
 * (dvec2(-0.42lf, 0.48lf) * dmat3x2(-0.36lf, -0.53lf, -1.08lf, 0.88lf, -0.6lf, -1.79lf)) => dvec3(-0.10320000000000001lf, 0.876lf, -0.6072lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.1lf, -1.2lf) * dmat3x2(0.09lf, -1.19lf, 1.3lf, 0.08lf, 1.25lf, 1.08lf)), dvec3(1.4189999999999998lf, -0.226lf, -1.421lf)) <= 2.0208607077183723e-05lf ? 1 : -1] array0;
  double[distance((dvec2(-0.1lf, -1.2lf) * dmat3x2(-0.36lf, -0.53lf, -1.08lf, 0.88lf, -0.6lf, -1.79lf)), dvec3(0.672lf, -0.948lf, 2.208lf)) <= 2.495105608987323e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.42lf, 0.48lf) * dmat3x2(0.09lf, -1.19lf, 1.3lf, 0.08lf, 1.25lf, 1.08lf)), dvec3(-0.609lf, -0.5076lf, -0.006599999999999965lf)) <= 7.928318358895536e-06lf ? 1 : -1] array2;
  double[distance((dvec2(-0.42lf, 0.48lf) * dmat3x2(-0.36lf, -0.53lf, -1.08lf, 0.88lf, -0.6lf, -1.79lf)), dvec3(-0.10320000000000001lf, 0.876lf, -0.6072lf)) <= 1.0708492330855917e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
