/*
 * Decompiled with CFR 0.152.
 */
package org.projectlibre.core.util;

import java.util.StringTokenizer;
import org.projectlibre.core.util.ArrayFormatException;

public class ArrayUtil {
    public static double[][] stringToPath(String string) throws ArrayFormatException {
        string = string.replaceAll("^\\s*,?\\s*[\\(\\{\\[]", "");
        string = string.replaceAll("[\\)\\}\\]]\\s*,?\\s*$", "");
        String[] stringArray = string.split("[\\)\\}\\]]\\s*,?\\s*[\\(\\{\\[]");
        double[][] dArray = new double[stringArray.length][2];
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray2 = ArrayUtil.stringToCoordinates(stringArray[i]);
            dArray[i] = dArray2;
        }
        return dArray;
    }

    public static String pathToString(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            ArrayUtil.coordinatesToString(dArray[i], stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static double[] stringToCoordinates(String string) throws ArrayFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        if (stringTokenizer.countTokens() != 2) {
            throw ArrayFormatException.forInputString(string);
        }
        return new double[]{Double.parseDouble(stringTokenizer.nextToken().trim()), Double.parseDouble(stringTokenizer.nextToken().trim())};
    }

    public static String coordinatesToString(double[] dArray) {
        return ArrayUtil.coordinatesToString(dArray, new StringBuilder()).toString();
    }

    private static StringBuilder coordinatesToString(double[] dArray, StringBuilder stringBuilder) {
        return stringBuilder.append('{').append(dArray[0]).append(", ").append(dArray[1]).append("}");
    }
}

