/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;

public class ASTHelper {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private SourceUnit controller;
    private ClassLoader classLoader;
    private Map imports;
    protected ModuleNode output;
    private String packageName;
    protected static HashMap resolutions = new HashMap();
    private static String NOT_RESOLVED = new String();
    private List newClasses = new ArrayList();

    public ASTHelper(SourceUnit controller, ClassLoader classLoader) {
        this();
        this.controller = controller;
        this.classLoader = classLoader;
    }

    public ASTHelper() {
        this.imports = new HashMap();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        if (packageName != null && packageName.length() > 0) {
            packageName = packageName + '.';
        }
        this.output.setPackageName(packageName);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SourceUnit getController() {
        return this.controller;
    }

    public void setController(SourceUnit controller) {
        this.controller = controller;
    }

    public static String dot(String base, String name) {
        if (base != null && base.length() > 0) {
            return base + "." + name;
        }
        return name;
    }

    protected void makeModule() {
        this.newClasses.clear();
        this.output = new ModuleNode(this.controller);
        resolutions.clear();
    }

    protected String dot(String base) {
        return ASTHelper.dot(base, "");
    }

    protected void addNewClassName(String name) {
        this.newClasses.add(name);
    }

    protected void importClass(ClassNode type, String name, String as) {
        if (as == null) {
            as = name;
        }
        this.output.addImport(as, type);
        this.imports.put(as, type);
    }

    protected void importPackageWithStar(String importPackage) {
        String[] classes = this.output.addImportPackage(this.dot(importPackage));
        for (int i = 0; i < classes.length; ++i) {
            this.imports.put(classes[i], ASTHelper.dot(importPackage, classes[i]));
        }
    }
}

