/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.FutureArrays;

public abstract class PointRangeQuery
extends Query {
    final String field;
    final int numDims;
    final int bytesPerDim;
    final byte[] lowerPoint;
    final byte[] upperPoint;

    protected PointRangeQuery(String field, byte[] lowerPoint, byte[] upperPoint, int numDims) {
        PointRangeQuery.checkArgs(field, lowerPoint, upperPoint);
        this.field = field;
        if (numDims <= 0) {
            throw new IllegalArgumentException("numDims must be positive, got " + numDims);
        }
        if (lowerPoint.length == 0) {
            throw new IllegalArgumentException("lowerPoint has length of zero");
        }
        if (lowerPoint.length % numDims != 0) {
            throw new IllegalArgumentException("lowerPoint is not a fixed multiple of numDims");
        }
        if (lowerPoint.length != upperPoint.length) {
            throw new IllegalArgumentException("lowerPoint has length=" + lowerPoint.length + " but upperPoint has different length=" + upperPoint.length);
        }
        this.numDims = numDims;
        this.bytesPerDim = lowerPoint.length / numDims;
        this.lowerPoint = lowerPoint;
        this.upperPoint = upperPoint;
    }

    public static void checkArgs(String field, Object lowerPoint, Object upperPoint) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (lowerPoint == null) {
            throw new IllegalArgumentException("lowerPoint must not be null");
        }
        if (upperPoint == null) {
            throw new IllegalArgumentException("upperPoint must not be null");
        }
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            private boolean matches(byte[] packedValue) {
                for (int dim = 0; dim < PointRangeQuery.this.numDims; ++dim) {
                    int offset = dim * PointRangeQuery.this.bytesPerDim;
                    if (FutureArrays.compareUnsigned(packedValue, offset, offset + PointRangeQuery.this.bytesPerDim, PointRangeQuery.this.lowerPoint, offset, offset + PointRangeQuery.this.bytesPerDim) < 0) {
                        return false;
                    }
                    if (FutureArrays.compareUnsigned(packedValue, offset, offset + PointRangeQuery.this.bytesPerDim, PointRangeQuery.this.upperPoint, offset, offset + PointRangeQuery.this.bytesPerDim) <= 0) continue;
                    return false;
                }
                return true;
            }

            private PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                boolean crosses = false;
                for (int dim = 0; dim < PointRangeQuery.this.numDims; ++dim) {
                    int offset = dim * PointRangeQuery.this.bytesPerDim;
                    if (FutureArrays.compareUnsigned(minPackedValue, offset, offset + PointRangeQuery.this.bytesPerDim, PointRangeQuery.this.upperPoint, offset, offset + PointRangeQuery.this.bytesPerDim) > 0 || FutureArrays.compareUnsigned(maxPackedValue, offset, offset + PointRangeQuery.this.bytesPerDim, PointRangeQuery.this.lowerPoint, offset, offset + PointRangeQuery.this.bytesPerDim) < 0) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    crosses |= FutureArrays.compareUnsigned(minPackedValue, offset, offset + PointRangeQuery.this.bytesPerDim, PointRangeQuery.this.lowerPoint, offset, offset + PointRangeQuery.this.bytesPerDim) < 0 || FutureArrays.compareUnsigned(maxPackedValue, offset, offset + PointRangeQuery.this.bytesPerDim, PointRangeQuery.this.upperPoint, offset, offset + PointRangeQuery.this.bytesPerDim) > 0;
                }
                if (crosses) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (this.matches(packedValue)) {
                            int docID;
                            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                                this.visit(docID);
                            }
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return this.relate(minPackedValue, maxPackedValue);
                    }
                };
            }

            private PointValues.IntersectVisitor getInverseIntersectVisitor(final FixedBitSet result, final int[] cost) {
                return new PointValues.IntersectVisitor(){

                    @Override
                    public void visit(int docID) {
                        result.clear(docID);
                        cost[0] = cost[0] - 1;
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (!this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (!this.matches(packedValue)) {
                            int docID;
                            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                                this.visit(docID);
                            }
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        PointValues.Relation relation = this.relate(minPackedValue, maxPackedValue);
                        switch (relation) {
                            case CELL_INSIDE_QUERY: {
                                return PointValues.Relation.CELL_OUTSIDE_QUERY;
                            }
                            case CELL_OUTSIDE_QUERY: {
                                return PointValues.Relation.CELL_INSIDE_QUERY;
                            }
                        }
                        return relation;
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                boolean allDocsMatch;
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(PointRangeQuery.this.field);
                if (values == null) {
                    return null;
                }
                if (values.getNumIndexDimensions() != PointRangeQuery.this.numDims) {
                    throw new IllegalArgumentException("field=\"" + PointRangeQuery.this.field + "\" was indexed with numIndexDimensions=" + values.getNumIndexDimensions() + " but this query has numDims=" + PointRangeQuery.this.numDims);
                }
                if (PointRangeQuery.this.bytesPerDim != values.getBytesPerDimension()) {
                    throw new IllegalArgumentException("field=\"" + PointRangeQuery.this.field + "\" was indexed with bytesPerDim=" + values.getBytesPerDimension() + " but this query has bytesPerDim=" + PointRangeQuery.this.bytesPerDim);
                }
                if (values.getDocCount() == reader.maxDoc()) {
                    byte[] fieldPackedLower = values.getMinPackedValue();
                    byte[] fieldPackedUpper = values.getMaxPackedValue();
                    allDocsMatch = true;
                    for (int i = 0; i < PointRangeQuery.this.numDims; ++i) {
                        int offset = i * PointRangeQuery.this.bytesPerDim;
                        if (FutureArrays.compareUnsigned(PointRangeQuery.this.lowerPoint, offset, offset + PointRangeQuery.this.bytesPerDim, fieldPackedLower, offset, offset + PointRangeQuery.this.bytesPerDim) <= 0 && FutureArrays.compareUnsigned(PointRangeQuery.this.upperPoint, offset, offset + PointRangeQuery.this.bytesPerDim, fieldPackedUpper, offset, offset + PointRangeQuery.this.bytesPerDim) >= 0) continue;
                        allDocsMatch = false;
                        break;
                    }
                } else {
                    allDocsMatch = false;
                }
                final 1 weight = this;
                if (allDocsMatch) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.all(reader.maxDoc()));
                        }

                        @Override
                        public long cost() {
                            return reader.maxDoc();
                        }
                    };
                }
                return new ScorerSupplier(){
                    final DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    long cost;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, PointRangeQuery.this.field);
                        this.visitor = this.getIntersectVisitor(this.result);
                        this.cost = -1L;
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        if (values.getDocCount() == reader.maxDoc() && (long)values.getDocCount() == values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                            FixedBitSet result = new FixedBitSet(reader.maxDoc());
                            result.set(0, reader.maxDoc());
                            int[] cost = new int[]{reader.maxDoc()};
                            values.intersect(this.getInverseIntersectVisitor(result, cost));
                            BitSetIterator iterator = new BitSetIterator(result, cost[0]);
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                        }
                        values.intersect(this.visitor);
                        DocIdSetIterator iterator = this.result.build().iterator();
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimatePointCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int getBytesPerDim() {
        return this.bytesPerDim;
    }

    public byte[] getLowerPoint() {
        return (byte[])this.lowerPoint.clone();
    }

    public byte[] getUpperPoint() {
        return (byte[])this.upperPoint.clone();
    }

    @Override
    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.lowerPoint);
        hash = 31 * hash + Arrays.hashCode(this.upperPoint);
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + Objects.hashCode(this.bytesPerDim);
        return hash;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((PointRangeQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(PointRangeQuery other) {
        return Objects.equals(this.field, other.field) && this.numDims == other.numDims && this.bytesPerDim == other.bytesPerDim && Arrays.equals(this.lowerPoint, other.lowerPoint) && Arrays.equals(this.upperPoint, other.upperPoint);
    }

    @Override
    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        for (int i = 0; i < this.numDims; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            int startOffset = this.bytesPerDim * i;
            sb.append('[');
            sb.append(this.toString(i, ArrayUtil.copyOfSubArray(this.lowerPoint, startOffset, startOffset + this.bytesPerDim)));
            sb.append(" TO ");
            sb.append(this.toString(i, ArrayUtil.copyOfSubArray(this.upperPoint, startOffset, startOffset + this.bytesPerDim)));
            sb.append(']');
        }
        return sb.toString();
    }

    protected abstract String toString(int var1, byte[] var2);
}

