/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfBitmap16;
import org.apache.poi.hwmf.record.HwmfBitmapDib;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.hwmf.record.HwmfTernaryRasterOp;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfFill {

    public static class WmfDibStretchBlt
    implements HwmfRecord,
    HwmfImageRecord,
    HwmfObjectTableEntry {
        private HwmfTernaryRasterOp rasterOperation;
        private int srcHeight;
        private int srcWidth;
        private int ySrc;
        private int xSrc;
        private int destHeight;
        private int destWidth;
        private int yDest;
        private int xDest;
        HwmfBitmapDib target;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.dibStretchBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            boolean hasBitmap = recordSize > (long)((recordFunction >> 8) + 3);
            int size = 0;
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            this.srcHeight = leis.readShort();
            this.srcWidth = leis.readShort();
            this.ySrc = leis.readShort();
            this.xSrc = leis.readShort();
            size = 12;
            if (!hasBitmap) {
                leis.readShort();
                size += 2;
            }
            this.destHeight = leis.readShort();
            this.destWidth = leis.readShort();
            this.yDest = leis.readShort();
            this.xDest = leis.readShort();
            size += 8;
            if (hasBitmap) {
                this.target = new HwmfBitmapDib();
                size += this.target.init(leis, (int)(recordSize - 6L - (long)size));
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }

        @Override
        public BufferedImage getImage() {
            return this.target.getImage();
        }
    }

    public static class WmfDibBitBlt
    implements HwmfRecord,
    HwmfImageRecord,
    HwmfObjectTableEntry {
        HwmfTernaryRasterOp rasterOperation;
        private int ySrc;
        private int xSrc;
        private int height;
        private int width;
        private int yDest;
        private int xDest;
        private HwmfBitmapDib target;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.dibBitBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            boolean hasBitmap = recordSize / 2L != (long)((recordFunction >> 8) + 3);
            int size = 0;
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            this.ySrc = leis.readShort();
            this.xSrc = leis.readShort();
            size = 8;
            if (!hasBitmap) {
                leis.readShort();
                size += 2;
            }
            this.height = leis.readShort();
            this.width = leis.readShort();
            this.yDest = leis.readShort();
            this.xDest = leis.readShort();
            size += 8;
            if (hasBitmap) {
                this.target = new HwmfBitmapDib();
                size += this.target.init(leis, (int)(recordSize - 6L - (long)size));
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }

        @Override
        public BufferedImage getImage() {
            return this.target == null ? null : this.target.getImage();
        }
    }

    public static class WmfSetDibToDev
    implements HwmfRecord,
    HwmfImageRecord,
    HwmfObjectTableEntry {
        private ColorUsage colorUsage;
        private int scanCount;
        private int startScan;
        private int yDib;
        private int xDib;
        private int height;
        private int width;
        private int yDest;
        private int xDest;
        private HwmfBitmapDib dib;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setDibToDev;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.colorUsage = ColorUsage.valueOf(leis.readUShort());
            this.scanCount = leis.readUShort();
            this.startScan = leis.readUShort();
            this.yDib = leis.readUShort();
            this.xDib = leis.readUShort();
            this.height = leis.readUShort();
            this.width = leis.readUShort();
            this.yDest = leis.readUShort();
            this.xDest = leis.readUShort();
            int size = 18;
            this.dib = new HwmfBitmapDib();
            size += this.dib.init(leis, (int)(recordSize - 6L - (long)size));
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }

        @Override
        public BufferedImage getImage() {
            return this.dib.getImage();
        }
    }

    public static class WmfBitBlt
    implements HwmfRecord {
        private HwmfTernaryRasterOp rasterOperation;
        private int ySrc;
        private int xSrc;
        private int height;
        private int width;
        private int yDest;
        private int xDest;
        private HwmfBitmap16 target;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.bitBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            boolean hasBitmap = recordSize / 2L != (long)((recordFunction >> 8) + 3);
            int size = 0;
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            this.ySrc = leis.readShort();
            this.xSrc = leis.readShort();
            size = 8;
            if (!hasBitmap) {
                leis.readShort();
                size += 2;
            }
            this.height = leis.readShort();
            this.width = leis.readShort();
            this.yDest = leis.readShort();
            this.xDest = leis.readShort();
            size += 8;
            if (hasBitmap) {
                this.target = new HwmfBitmap16();
                size += this.target.init(leis);
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfStretchDib
    implements HwmfRecord,
    HwmfImageRecord,
    HwmfObjectTableEntry {
        private HwmfTernaryRasterOp rasterOperation;
        private ColorUsage colorUsage;
        private int srcHeight;
        private int srcWidth;
        private int ySrc;
        private int xSrc;
        private int destHeight;
        private int destWidth;
        private int yDst;
        private int xDst;
        private HwmfBitmapDib dib;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.stretchDib;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            this.colorUsage = ColorUsage.valueOf(leis.readUShort());
            this.srcHeight = leis.readShort();
            this.srcWidth = leis.readShort();
            this.ySrc = leis.readShort();
            this.xSrc = leis.readShort();
            this.destHeight = leis.readShort();
            this.destWidth = leis.readShort();
            this.yDst = leis.readShort();
            this.xDst = leis.readShort();
            int size = 22;
            this.dib = new HwmfBitmapDib();
            size += this.dib.init(leis, (int)(recordSize - 6L - (long)size));
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.addObjectTableEntry(this);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
        }

        @Override
        public BufferedImage getImage() {
            return this.dib.getImage();
        }
    }

    public static class WmfStretchBlt
    implements HwmfRecord {
        private HwmfTernaryRasterOp rasterOperation;
        private int srcHeight;
        private int srcWidth;
        private int ySrc;
        private int xSrc;
        private int destHeight;
        private int destWidth;
        private int yDest;
        private int xDest;
        HwmfBitmap16 target;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.stretchBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            boolean hasBitmap = recordSize > (long)((recordFunction >> 8) + 3);
            int size = 0;
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            this.srcHeight = leis.readShort();
            this.srcWidth = leis.readShort();
            this.ySrc = leis.readShort();
            this.xSrc = leis.readShort();
            size = 12;
            if (!hasBitmap) {
                leis.readShort();
                size += 2;
            }
            this.destHeight = leis.readShort();
            this.destWidth = leis.readShort();
            this.yDest = leis.readShort();
            this.xDest = leis.readShort();
            size += 8;
            if (hasBitmap) {
                this.target = new HwmfBitmap16();
                size += this.target.init(leis);
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfPatBlt
    implements HwmfRecord {
        private HwmfTernaryRasterOp rasterOperation;
        private int height;
        private int width;
        private int yLeft;
        private int xLeft;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.patBlt;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int rasterOpCode = leis.readUShort();
            int rasterOpIndex = leis.readUShort();
            this.rasterOperation = HwmfTernaryRasterOp.valueOf(rasterOpIndex);
            assert (rasterOpCode == this.rasterOperation.opCode);
            this.height = leis.readShort();
            this.width = leis.readShort();
            this.yLeft = leis.readShort();
            this.xLeft = leis.readShort();
            return 12;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfInvertRegion
    implements HwmfRecord {
        private int region;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.invertRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.region = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfExtFloodFill
    implements HwmfRecord {
        private int mode;
        private HwmfColorRef colorRef;
        private int y;
        private int x;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.extFloodFill;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.mode = leis.readUShort();
            this.colorRef = new HwmfColorRef();
            int size = this.colorRef.init(leis);
            this.y = leis.readShort();
            this.x = leis.readShort();
            return size + 6;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfSetPolyfillMode
    implements HwmfRecord {
        private HwmfPolyfillMode polyfillMode;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.setPolyFillMode;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.polyfillMode = HwmfPolyfillMode.valueOf(leis.readUShort() & 3);
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setPolyfillMode(this.polyfillMode);
        }

        public static enum HwmfPolyfillMode {
            ALTERNATE(1, 0),
            WINDING(2, 1);

            public final int wmfFlag;
            public final int awtFlag;

            private HwmfPolyfillMode(int wmfFlag, int awtFlag) {
                this.wmfFlag = wmfFlag;
                this.awtFlag = awtFlag;
            }

            static HwmfPolyfillMode valueOf(int wmfFlag) {
                for (HwmfPolyfillMode pm : HwmfPolyfillMode.values()) {
                    if (pm.wmfFlag != wmfFlag) continue;
                    return pm;
                }
                return null;
            }
        }
    }

    public static class WmfFloodFill
    implements HwmfRecord {
        private HwmfColorRef colorRef;
        private int yStart;
        private int xStart;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.floodFill;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.colorRef = new HwmfColorRef();
            int size = this.colorRef.init(leis);
            this.yStart = leis.readShort();
            this.xStart = leis.readShort();
            return size + 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
        }
    }

    public static class WmfPaintRegion
    implements HwmfRecord {
        int regionIndex;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.paintRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.regionIndex = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.applyObjectTableEntry(this.regionIndex);
            Shape region = ctx.getProperties().getRegion();
            if (region != null) {
                ctx.fill(region);
            }
        }
    }

    public static class WmfFillRegion
    implements HwmfRecord {
        private int regionIndex;
        private int brushIndex;

        @Override
        public HwmfRecordType getRecordType() {
            return HwmfRecordType.fillRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.regionIndex = leis.readUShort();
            this.brushIndex = leis.readUShort();
            return 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.applyObjectTableEntry(this.regionIndex);
            ctx.applyObjectTableEntry(this.brushIndex);
            Shape region = ctx.getProperties().getRegion();
            if (region != null) {
                ctx.fill(region);
            }
        }
    }

    public static enum ColorUsage {
        DIB_RGB_COLORS(0),
        DIB_PAL_COLORS(1),
        DIB_PAL_INDICES(2);

        public final int flag;

        private ColorUsage(int flag) {
            this.flag = flag;
        }

        static ColorUsage valueOf(int flag) {
            for (ColorUsage bs : ColorUsage.values()) {
                if (bs.flag != flag) continue;
                return bs;
            }
            return null;
        }
    }

    public static interface HwmfImageRecord {
        public BufferedImage getImage();
    }
}

