/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicate;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$5;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$6;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$9;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$ArrayItr;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$ConcatenatedIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$EmptyModifiableIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableListIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Iterators {
    static UnmodifiableIterator emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static UnmodifiableListIterator emptyListIterator() {
        return Iterators$ArrayItr.EMPTY;
    }

    static Iterator emptyModifiableIterator() {
        return Iterators$EmptyModifiableIterator.INSTANCE;
    }

    public static UnmodifiableIterator unmodifiableIterator(Iterator iterator) {
        Preconditions.checkNotNull(iterator);
        if (iterator instanceof UnmodifiableIterator) {
            UnmodifiableIterator unmodifiableIterator = (UnmodifiableIterator)iterator;
            return unmodifiableIterator;
        }
        return new Iterators$1(iterator);
    }

    public static boolean contains(Iterator iterator, @NullableDecl Object object) {
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    @CanIgnoreReturnValue
    public static boolean removeAll(Iterator iterator, Collection collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @CanIgnoreReturnValue
    public static boolean retainAll(Iterator iterator, Collection collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean elementsEqual(Iterator iterator, Iterator iterator2) {
        while (iterator.hasNext()) {
            Object e;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object e2 = iterator.next();
            if (Objects.equal(e2, e = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator iterator) {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.append(']').toString();
    }

    @CanIgnoreReturnValue
    public static Object getOnlyElement(Iterator iterator) {
        Object e = iterator.next();
        if (!iterator.hasNext()) {
            return e;
        }
        StringBuilder stringBuilder = new StringBuilder().append("expected one element but was: <").append(e);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            stringBuilder.append(", ").append(iterator.next());
        }
        if (iterator.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @CanIgnoreReturnValue
    public static boolean addAll(Collection collection, Iterator iterator) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    private static Iterator consumingForArray(Object ... objectArray) {
        return new Iterators$3(objectArray);
    }

    public static Iterator concat(Iterator iterator, Iterator iterator2) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(iterator2);
        return Iterators.concat(Iterators.consumingForArray(iterator, iterator2));
    }

    public static Iterator concat(Iterator iterator) {
        return new Iterators$ConcatenatedIterator(iterator);
    }

    public static UnmodifiableIterator filter(Iterator iterator, Predicate predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        return new Iterators$5(iterator, predicate);
    }

    public static Iterator transform(Iterator iterator, Function function) {
        Preconditions.checkNotNull(function);
        return new Iterators$6(iterator, function);
    }

    @NullableDecl
    public static Object getNext(Iterator iterator, @NullableDecl Object object) {
        return iterator.hasNext() ? iterator.next() : object;
    }

    @NullableDecl
    static Object pollNext(Iterator iterator) {
        if (iterator.hasNext()) {
            Object e = iterator.next();
            iterator.remove();
            return e;
        }
        return null;
    }

    static void clear(Iterator iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @SafeVarargs
    public static UnmodifiableIterator forArray(Object ... objectArray) {
        return Iterators.forArray(objectArray, 0, objectArray.length, 0);
    }

    static UnmodifiableListIterator forArray(Object[] objectArray, int n, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0);
        int n4 = n + n2;
        Preconditions.checkPositionIndexes(n, n4, objectArray.length);
        Preconditions.checkPositionIndex(n3, n2);
        if (n2 == 0) {
            return Iterators.emptyListIterator();
        }
        return new Iterators$ArrayItr(objectArray, n, n2, n3);
    }

    public static UnmodifiableIterator singletonIterator(@NullableDecl Object object) {
        return new Iterators$9(object);
    }

    static ListIterator cast(Iterator iterator) {
        return (ListIterator)iterator;
    }
}

