/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EvalStream
extends TupleStream
implements Expressible {
    private TupleStream stream;
    private TupleStream evalStream;
    private StreamFactory streamFactory;
    private StreamContext streamContext;

    public EvalStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        TupleStream stream = factory.constructStream(streamExpressions.get(0));
        this.init(stream, factory);
    }

    private void init(TupleStream tupleStream, StreamFactory factory) throws IOException {
        this.stream = tupleStream;
        this.streamFactory = factory;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (this.stream instanceof Expressible) {
                expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
            } else {
                throw new IOException("The EvalStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            }
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
        this.stream.setStreamContext(streamContext);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        try {
            this.stream.open();
            Tuple tuple = this.stream.read();
            String expr = tuple.getString("expr_s");
            if (expr == null) {
                throw new IOException("expr_s cannot be empty for the EvalStream");
            }
            this.evalStream = this.streamFactory.constructStream(expr);
            this.evalStream.setStreamContext(this.streamContext);
            this.evalStream.open();
        }
        finally {
            this.stream.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.evalStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        return this.evalStream.read();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

